/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.network.fx.MessageIcedTouchFX;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.modules.ModuleRegistry;
import epicsquid.roots.spell.modules.SpellModule;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellIcedTouch
extends SpellBase {
    public static String spellName = "spell_iced_touch";
    public static SpellIcedTouch instance = new SpellIcedTouch(spellName);

    public SpellIcedTouch(String name) {
        super(name, TextFormatting.DARK_AQUA, 0.08627451f, 0.5568628f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.castType = SpellBase.EnumCastType.INSTANTANEOUS;
        this.cooldown = 100;
        this.addCost(HerbRegistry.getHerbByName("dewgonia"), 0.015f);
        this.addIngredients(new ItemStack(ModItems.dewgonia), new ItemStack(Item.func_150898_a((Block)Blocks.field_150433_aE)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150431_aC)), new ItemStack(Items.field_151126_ay), new ItemStack(Item.func_150898_a((Block)Blocks.field_150328_O), 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()));
        this.acceptModules(ModuleRegistry.module_touch);
    }

    @Override
    public boolean cast(EntityPlayer player, List<SpellModule> modules) {
        World world = player.field_70170_p;
        if (modules.contains(ModuleRegistry.module_touch)) {
            if (!world.field_72995_K) {
                player.func_70690_d(new PotionEffect(ModPotions.freeze, 600, 0, false, false));
            }
            return true;
        }
        RayTraceResult result = this.rayTrace(player, player.func_70093_af() ? 1.0 : 10.0);
        if (result != null && !player.func_70093_af() && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState down;
            BlockPos pos = result.func_178782_a().func_177972_a(result.field_178784_b);
            IBlockState state = world.func_180495_p(pos);
            boolean didSpell = false;
            if (state.func_177230_c() == Blocks.field_150480_ab) {
                didSpell = true;
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.3f, 1.0f);
                }
            } else if (state.func_177230_c() == Blocks.field_150353_l) {
                if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    didSpell = true;
                    if (!world.field_72995_K) {
                        world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                        world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.PLAYERS, 0.3f, 1.0f);
                    }
                } else {
                    didSpell = true;
                    if (!world.field_72995_K) {
                        world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
                        world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.PLAYERS, 0.3f, 1.0f);
                    }
                }
            } else if (state.func_177230_c() == Blocks.field_150355_j) {
                if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    didSpell = true;
                    if (!world.field_72995_K) {
                        world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                        world.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 0.3f, 1.0f);
                    }
                }
            } else if (world.func_175623_d(pos) && (down = world.func_180495_p(pos.func_177977_b())).func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) == BlockFaceShape.SOLID) {
                didSpell = true;
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                    world.func_184133_a(null, pos, SoundEvents.field_187552_ah, SoundCategory.PLAYERS, 0.3f, 1.0f);
                }
            }
            if (didSpell) {
                PacketHandler.sendToAllTracking((IMessage)new MessageIcedTouchFX(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (Entity)player);
            }
            return didSpell;
        }
        return false;
    }

    @Nullable
    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance) {
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }
}

