/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.ListUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.block.BlockBonfire;
import epicsquid.roots.config.RitualConfig;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.entity.ritual.EntityRitualFrostLands;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.ritual.IColdRitual;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.util.ItemHandlerUtil;
import epicsquid.roots.util.XPUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBonfire
extends TileBase
implements ITickable {
    public static AxisAlignedBB bounding = new AxisAlignedBB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0);
    private float ticker = 0.0f;
    private float pickupDelay = 0.0f;
    private int burnTime = 0;
    private boolean doBigFlame = false;
    private ItemStack craftingResult = ItemStack.field_190927_a;
    private int craftingXP = 0;
    private RitualBase lastRitualUsed = null;
    private PyreCraftingRecipe lastRecipeUsed = null;
    private List<Ingredient> lastUsedIngredients = null;
    private EntityRitualBase ritualEntity = null;
    private boolean isBurning = false;
    private Random random = new Random();
    public ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            if (!((TileEntityBonfire)TileEntityBonfire.this).field_145850_b.field_72995_K) {
                TileEntityBonfire.this.func_70296_d();
                TileEntityBonfire.this.updatePacketViaState();
            }
        }
    };
    public ItemStackHandler inventory_storage = new ItemStackHandler(5);

    public void clearStorage() {
        for (int i = 0; i < 5; ++i) {
            this.inventory_storage.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74757_a("doBigFlame", this.doBigFlame);
        tag.func_74782_a("craftingResult", (NBTBase)this.craftingResult.serializeNBT());
        tag.func_74768_a("craftingXP", this.craftingXP);
        tag.func_74778_a("lastRitualUsed", this.lastRitualUsed != null ? this.lastRitualUsed.getName() : "");
        tag.func_74778_a("lastRecipeUsed", this.lastRecipeUsed != null ? this.lastRecipeUsed.getName() : "");
        tag.func_74768_a("entity", this.ritualEntity == null ? -1 : this.ritualEntity.func_145782_y());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        this.burnTime = tag.func_74762_e("burnTime");
        this.doBigFlame = tag.func_74767_n("doBigFlame");
        this.craftingResult = new ItemStack(tag.func_74775_l("craftingResult"));
        this.craftingXP = tag.func_74762_e("craftingXP");
        this.lastRitualUsed = RitualRegistry.getRitual(tag.func_74779_i("lastRitualUsed"));
        this.lastRecipeUsed = ModRecipes.getCraftingRecipe(tag.func_74779_i("lastRecipeUsed"));
        if (this.func_145830_o()) {
            this.ritualEntity = tag.func_74762_e("entity") != -1 ? (EntityRitualBase)this.field_145850_b.func_73045_a(tag.func_74762_e("entity")) : null;
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public PyreCraftingRecipe getCurrentRecipe() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.extractItem(i, 1, true);
            stacks.add(stack);
        }
        return ModRecipes.getCraftingRecipe(stacks);
    }

    private void validateEntity() {
        if (this.ritualEntity == null) {
            return;
        }
        if (this.ritualEntity.field_70128_L) {
            return;
        }
        int lifetime = (Integer)this.ritualEntity.func_184212_Q().func_187225_a(this.ritualEntity.getLifetime());
        if (lifetime <= 0) {
            this.ritualEntity.func_70106_y();
        }
        if (this.burnTime <= 0) {
            this.ritualEntity.func_70106_y();
        }
    }

    private boolean startRitual(@Nullable EntityPlayer player) {
        RitualBase ritual = RitualRegistry.getRitual(this, player);
        this.validateEntity();
        if (ritual != null && !ritual.isDisabled() && (this.ritualEntity == null || this.ritualEntity.field_70128_L) && ritual.canFire(this, player)) {
            this.ritualEntity = ritual.doEffect(this.field_145850_b, this.field_174879_c);
            this.burnTime = ritual.getDuration();
            this.lastRitualUsed = ritual;
            this.lastRecipeUsed = null;
            this.lastUsedIngredients = ritual.getIngredients();
            this.doBigFlame = true;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack item = this.inventory.extractItem(i, 1, false);
                if (this.field_145850_b.field_72995_K || !item.func_77973_b().hasContainerItem(item)) continue;
                ItemStack container = ForgeHooks.getContainerItem((ItemStack)item);
                ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(1, 0, -1), (ItemStack)container);
            }
            this.func_70296_d();
            this.updatePacketViaState();
            return true;
        }
        PyreCraftingRecipe recipe = this.getCurrentRecipe();
        if (recipe != null) {
            this.lastRecipeUsed = recipe;
            this.lastRitualUsed = null;
            this.lastUsedIngredients = recipe.getIngredients();
            this.craftingResult = recipe.getResult();
            this.craftingXP = recipe.getXP();
            this.burnTime = recipe.getBurnTime();
            this.doBigFlame = true;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack item = this.inventory.extractItem(i, 1, false);
                this.inventory_storage.insertItem(i, item, false);
                if (this.field_145850_b.field_72995_K || !item.func_77973_b().hasContainerItem(item)) continue;
                ItemStack container = ForgeHooks.getContainerItem((ItemStack)item);
                ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(1, 0, -1), (ItemStack)container);
            }
            this.func_70296_d();
            this.updatePacketViaState();
            return true;
        }
        return false;
    }

    private void resolveLastIngredients() {
        if (this.lastUsedIngredients == null || this.lastUsedIngredients.isEmpty()) {
            if (this.lastRitualUsed != null) {
                this.lastUsedIngredients = this.lastRitualUsed.getIngredients();
            } else if (this.lastRecipeUsed != null) {
                this.lastUsedIngredients = this.lastRecipeUsed.getIngredients();
            }
        }
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        int i;
        if (world.field_72995_K) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            IFluidTankProperties[] props;
            boolean extinguish = false;
            IFluidHandlerItem cap = (IFluidHandlerItem)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (cap != null && (props = cap.getTankProperties()) != null && props.length >= 1) {
                for (IFluidTankProperties prop : props) {
                    FluidStack stack = prop.getContents();
                    if (stack != null) {
                        if (stack.getFluid().getTemperature() <= 300) {
                            extinguish = true;
                        } else if (RitualConfig.getExtinguishFluids().contains(stack.getFluid().getName())) {
                            extinguish = true;
                        }
                    }
                    if (!extinguish) continue;
                    if (stack.amount > 1000) {
                        stack.amount = 1000;
                    }
                    if (player.field_71075_bZ.field_75098_d) break;
                    cap.drain(stack, true);
                    if (!(heldItem.func_77973_b() instanceof ItemBucket)) break;
                    player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                    break;
                }
            }
            if (heldItem.func_77973_b() instanceof ItemFlintAndSteel) {
                heldItem.func_77972_a(1, (EntityLivingBase)player);
                return this.startRitual(player);
            }
            if (extinguish && this.burnTime > 0) {
                this.burnTime = 0;
                if (this.ritualEntity != null) {
                    this.ritualEntity.func_70106_y();
                }
                this.lastRecipeUsed = null;
                this.lastRitualUsed = null;
                BlockBonfire.setState(false, world, pos);
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                ItemStack attemptedInsert;
                if (!this.inventory.getStackInSlot(i2).func_190926_b()) continue;
                ItemStack toInsert = heldItem.func_77946_l();
                if (!player.func_70093_af()) {
                    toInsert.func_190920_e(1);
                }
                if (!(attemptedInsert = this.inventory.insertItem(i2, toInsert, true)).func_190926_b()) continue;
                this.inventory.insertItem(i2, toInsert, false);
                if (!player.func_70093_af()) {
                    heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                } else {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    player.func_184611_a(hand, heldItem);
                }
                this.func_70296_d();
                this.updatePacketViaState();
                return true;
            }
        }
        if (player.func_70093_af() && heldItem.func_190926_b() && hand == EnumHand.MAIN_HAND) {
            this.resolveLastIngredients();
            if (this.lastUsedIngredients != null) {
                if (player.field_71075_bZ.field_75098_d) {
                    i = 0;
                    for (Ingredient ingredient : this.lastUsedIngredients) {
                        this.inventory.setStackInSlot(i++, ingredient.func_193365_a()[0]);
                    }
                } else {
                    IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                    assert (inventory != null);
                    block3: for (Ingredient ingredient : this.lastUsedIngredients) {
                        for (int i3 = 0; i3 < inventory.getSlots(); ++i3) {
                            ItemStack stack = inventory.getStackInSlot(i3);
                            if (!ingredient.apply(stack)) continue;
                            this.insertItemFromPlayerInventory(stack, player, i3);
                            continue block3;
                        }
                    }
                }
            }
            return true;
        }
        if (heldItem.func_190926_b() && hand == EnumHand.MAIN_HAND) {
            for (i = 4; i >= 0; --i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemStack extracted = this.inventory.extractItem(i, this.inventory.getStackInSlot(i).func_190916_E(), false);
                ItemUtil.spawnItem((World)world, (double)player.field_70165_t, (double)(player.field_70163_u + 1.0), (double)player.field_70161_v, (boolean)false, (ItemStack)extracted, (int)0, (float)-1.0f);
                this.func_70296_d();
                this.updatePacketViaState();
                this.pickupDelay = 40.0f;
                return true;
            }
        }
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c() && newState.func_177230_c() == ModBlocks.bonfire) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void breakBlock(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IItemHandler cap;
            TileEntity te;
            this.resolveLastIngredients();
            if (this.lastUsedIngredients != null && !this.lastUsedIngredients.isEmpty() && ItemHandlerUtil.isEmpty((IItemHandler)this.inventory) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) != null && (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                List<ItemStack> temp;
                Int2ObjectOpenHashMap slotsToIngredient = new Int2ObjectOpenHashMap();
                int amount = 0;
                block0: for (Ingredient ingredient : this.lastUsedIngredients) {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        ItemStack inSlot = cap.getStackInSlot(i);
                        if (!ingredient.apply(inSlot)) continue;
                        if (slotsToIngredient.containsKey(i)) {
                            if (inSlot.func_190916_E() <= ((ItemHandlerUtil.IngredientWithStack)slotsToIngredient.get(i)).getCount()) continue;
                            ++amount;
                            ((ItemHandlerUtil.IngredientWithStack)slotsToIngredient.get(i)).increment();
                            continue block0;
                        }
                        ++amount;
                        slotsToIngredient.put(i, (Object)new ItemHandlerUtil.IngredientWithStack(ingredient, 1));
                        continue block0;
                    }
                }
                if (amount == 5 && (temp = ItemHandlerUtil.getItemsInSlots(cap, (Int2ObjectOpenHashMap<ItemHandlerUtil.IngredientWithStack>)slotsToIngredient, true)).size() == 5) {
                    temp = ItemHandlerUtil.getItemsInSlots(cap, (Int2ObjectOpenHashMap<ItemHandlerUtil.IngredientWithStack>)slotsToIngredient, false);
                    for (int i = 0; i < temp.size(); ++i) {
                        ItemStack stack = temp.get(i);
                        this.inventory.setStackInSlot(i, stack);
                    }
                }
            }
            if (this.ticker % 10.0f == 0.0f) {
                AxisAlignedBB bounds = bounding.func_186670_a(this.func_174877_v());
                BlockPos start = new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c);
                BlockPos stop = new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f);
                boolean fire = false;
                for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)start, (BlockPos)stop)) {
                    if (this.field_145850_b.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150480_ab) continue;
                    fire = true;
                    if (this.field_145850_b.func_180495_p(pos.func_177977_b()).func_177230_c().isFireSource(this.field_145850_b, pos.func_177977_b(), EnumFacing.UP)) continue;
                    for (int i = 0; i < 1 + Util.rand.nextInt(3); ++i) {
                        this.field_145850_b.func_180495_p((BlockPos)pos).func_177230_c().func_180645_a(this.field_145850_b, (BlockPos)pos, this.field_145850_b.func_180495_p((BlockPos)pos), Util.rand);
                    }
                }
                if (fire) {
                    this.startRitual(null);
                }
            }
        }
        this.ticker += 1.0f;
        if (this.pickupDelay > 0.0f) {
            this.pickupDelay -= 1.0f;
        }
        if (this.field_145850_b.field_72995_K && this.doBigFlame) {
            if (this.ritualEntity instanceof IColdRitual) {
                for (int i = 0; i < 40; ++i) {
                    ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.125f + 0.75f * this.random.nextFloat(), (float)this.func_174877_v().func_177956_o() + 0.75f + 0.5f * this.random.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.125f + 0.75f * this.random.nextFloat(), 0.03125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.03125f * (this.random.nextFloat() - 0.5f), 63.0f, 119.0f, 209.0f, 0.75f, 9.0f + 9.0f * this.random.nextFloat(), 40);
                }
            } else {
                for (int i = 0; i < 40; ++i) {
                    ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.125f + 0.75f * this.random.nextFloat(), (float)this.func_174877_v().func_177956_o() + 0.75f + 0.5f * this.random.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.125f + 0.75f * this.random.nextFloat(), 0.03125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.03125f * (this.random.nextFloat() - 0.5f), 255.0f, 224.0f, 32.0f, 0.75f, 9.0f + 9.0f * this.random.nextFloat(), 40);
                }
            }
        }
        if (this.doBigFlame) {
            if (this.burnTime != 0) {
                BlockBonfire.setState(true, this.field_145850_b, this.field_174879_c);
            }
            this.doBigFlame = false;
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.updatePacketViaState();
            }
        }
        if (this.burnTime > 0) {
            boolean burning;
            --this.burnTime;
            boolean bl = burning = this.burnTime > 0;
            if (this.ritualEntity != null && this.ritualEntity.field_70128_L && this.craftingResult.func_190926_b()) {
                burning = false;
            }
            if (burning && this.getTicker() % 20.0f == 0.0f && this.random.nextDouble() < 0.05 && !(this.ritualEntity instanceof IColdRitual)) {
                this.meltNearbySnow();
            }
            if (!burning || this.burnTime == 0) {
                int i;
                this.burnTime = 0;
                BlockBonfire.setState(false, this.field_145850_b, this.field_174879_c);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (i = 0; i < this.inventory.getSlots(); ++i) {
                    ItemStack stack = this.inventory.getStackInSlot(i).func_77946_l();
                    stack.func_190920_e(1);
                    stacks.add(stack);
                }
                if (this.craftingResult.func_190926_b() && this.lastRitualUsed != null) {
                    if (ListUtil.matchesIngredients(stacks, this.lastRitualUsed.getIngredients()) && this.lastRitualUsed.checkTileConditions(this, null)) {
                        this.lastRitualUsed.doEffect(this.field_145850_b, this.func_174877_v());
                        burning = true;
                        this.burnTime = this.lastRitualUsed.getDuration();
                        this.doBigFlame = true;
                        for (i = 0; i < this.inventory.getSlots(); ++i) {
                            this.inventory.extractItem(i, 1, false);
                        }
                        this.func_70296_d();
                        if (!this.field_145850_b.field_72995_K) {
                            this.updatePacketViaState();
                        }
                    }
                } else if (this.lastRecipeUsed != null && this.lastRecipeUsed.matches(stacks)) {
                    burning = true;
                    this.burnTime = this.lastRecipeUsed.getBurnTime();
                    this.doBigFlame = true;
                    for (i = 0; i < this.inventory.getSlots(); ++i) {
                        this.inventory.extractItem(i, 1, false);
                    }
                    this.func_70296_d();
                    if (!this.field_145850_b.field_72995_K) {
                        this.updatePacketViaState();
                    }
                }
                if (!this.field_145850_b.field_72995_K && !this.craftingResult.func_190926_b()) {
                    ItemStack result = this.craftingResult.func_77946_l();
                    if (this.lastRecipeUsed != null) {
                        this.lastRecipeUsed.postCraft(result, (IItemHandlerModifiable)this.inventory_storage, this);
                    }
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, result);
                    item.func_96094_a("bonfire");
                    ItemUtil.spawnItem((World)this.field_145850_b, (EntityItem)item);
                    XPUtil.spawnXP(this.field_145850_b, this.func_174877_v(), this.craftingXP);
                    this.craftingResult = ItemStack.field_190927_a;
                    this.clearStorage();
                }
            }
            if (burning && this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 2; ++i) {
                    if (this.ritualEntity instanceof EntityRitualFrostLands) {
                        ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.3125f + 0.375f * Util.rand.nextFloat(), (float)this.func_174877_v().func_177956_o() + 0.625f + 0.375f * Util.rand.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.3125f + 0.375f * Util.rand.nextFloat(), 0.03125f * (Util.rand.nextFloat() - 0.5f), 0.125f * Util.rand.nextFloat(), 0.03125f * (Util.rand.nextFloat() - 0.5f), 90.0f, 134.0f, 204.0f, 0.75f, 7.0f + 7.0f * Util.rand.nextFloat(), 40);
                        continue;
                    }
                    ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.3125f + 0.375f * Util.rand.nextFloat(), (float)this.func_174877_v().func_177956_o() + 0.625f + 0.375f * Util.rand.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.3125f + 0.375f * Util.rand.nextFloat(), 0.03125f * (Util.rand.nextFloat() - 0.5f), 0.125f * Util.rand.nextFloat(), 0.03125f * (Util.rand.nextFloat() - 0.5f), 255.0f, 96.0f, 32.0f, 0.75f, 7.0f + 7.0f * Util.rand.nextFloat(), 40);
                }
            }
            if (!burning || this.burnTime == 0) {
                this.burnTime = 0;
                this.func_70296_d();
                if (!this.field_145850_b.field_72995_K) {
                    this.updatePacketViaState();
                }
            }
        }
        this.pickupItem();
    }

    private void meltNearbySnow() {
        ArrayList<BlockPos> nearbySnowOrIce = new ArrayList<BlockPos>();
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                BlockPos topBlockPos = this.field_145850_b.func_175672_r(new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + z));
                IBlockState topBlockState = this.field_145850_b.func_180495_p(topBlockPos = topBlockPos.func_177973_b(new Vec3i(0, 1, 0)));
                if (topBlockState.func_185904_a() != Material.field_151597_y && topBlockState.func_185904_a() != Material.field_151588_w) continue;
                nearbySnowOrIce.add(topBlockPos);
            }
        }
        if (nearbySnowOrIce.isEmpty()) {
            return;
        }
        BlockPos posToMelt = (BlockPos)nearbySnowOrIce.get(nearbySnowOrIce.size() > 1 ? this.random.nextInt(nearbySnowOrIce.size() - 1) : 0);
        if (this.field_145850_b.func_180495_p(posToMelt).func_185904_a() == Material.field_151597_y) {
            this.field_145850_b.func_175656_a(posToMelt, Blocks.field_150350_a.func_176223_P());
        } else if (this.field_145850_b.func_180495_p(posToMelt).func_185904_a() == Material.field_151588_w) {
            this.field_145850_b.func_175656_a(posToMelt, Blocks.field_150355_j.func_176223_P());
        }
    }

    private void pickupItem() {
        if ((int)this.ticker % 20 == 0 && this.pickupDelay == 0.0f) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)));
            for (EntityItem item : items) {
                ItemStack stack = item.func_92059_d();
                if (item.func_95999_t().equalsIgnoreCase("bonfire")) continue;
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                    ItemStack inputStack = stack.func_77946_l();
                    inputStack.func_190920_e(1);
                    this.inventory.insertItem(i, inputStack, false);
                    stack.func_190918_g(1);
                }
                this.func_70296_d();
                if (this.field_145850_b.field_72995_K) continue;
                this.updatePacketViaState();
            }
        }
    }

    private void insertItemFromPlayerInventory(ItemStack stack, EntityPlayer player, int slot) {
        for (int i = 0; i < 5; ++i) {
            if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190920_e(1);
            this.inventory.insertItem(i, toInsert, false);
            stack.func_190920_e(stack.func_190916_E() - 1);
            this.func_70296_d();
            if (this.field_145850_b.field_72995_K) break;
            this.updatePacketViaState();
            break;
        }
    }

    public RitualBase getLastRitualUsed() {
        return this.lastRitualUsed;
    }

    public PyreCraftingRecipe getLastRecipeUsed() {
        return this.lastRecipeUsed;
    }

    public void setLastRitualUsed(RitualBase lastRitualUsed) {
        this.lastRitualUsed = lastRitualUsed;
    }

    public void setLastRecipeUsed(PyreCraftingRecipe lastRecipeUsed) {
        this.lastRecipeUsed = lastRecipeUsed;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public boolean getState() {
        return this.isBurning;
    }

    public float getTicker() {
        return this.ticker;
    }
}

