/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureBase {
    private ArrayList<String[]> layers = new ArrayList();
    private int width;
    private int length;
    private Map<String, IBlockState> blocks = new HashMap<String, IBlockState>();

    public StructureBase(int w, int h) {
        this.width = w;
        this.length = h;
    }

    public StructureBase addLayer(String[] layer) {
        this.layers.add(layer);
        return this;
    }

    public void generateIn(World world, int x, int y, int z) {
        for (int i = 0; i < this.layers.size(); ++i) {
            for (int j = 0; j < this.layers.get(i).length; ++j) {
                for (int k = 0; k < this.layers.get(i)[j].length(); ++k) {
                    this.placeBlock(world, new BlockPos(x + j - this.width / 2, y + i, z + k - this.length / 2), this.blocks.get(this.layers.get(i)[j].substring(k, k + 1)));
                }
            }
        }
    }

    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != Blocks.field_150350_a) {
            world.func_175656_a(pos, state);
        }
    }

    public StructureBase addBlockMapping(String name, IBlockState state) {
        this.blocks.put(name, state);
        return this;
    }
}

