/*
 * Decompiled with CFR 0.152.
 */
package saracalia.scm;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.mc.network.SimpleUpdateHandler;
import net.fexcraft.lib.mc.registry.FCLRegistry;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import saracalia.scm.blocks.BlockBase;
import saracalia.scm.blocks.SCMBlocks;
import saracalia.scm.gui.GuiHandler;
import saracalia.scm.util.Config;
import saracalia.scm.util.FillerUtil;

@Mod(modid="scm", name="Saracalia's City Mod", version="1.0.03a", dependencies="required-after:fcl", acceptedMinecraftVersions="*", acceptableRemoteVersions="*")
public class SCM {
    public static final String MODID = "scm";
    public static final String NAME = "Saracalia's City Mod";
    public static final String VERSION = "1.0.03a";
    public static FCLRegistry.AutoRegisterer AUTOREG;
    public static Logger LOGGER;
    public static Item STICK_A;
    public static Item STICK_B;
    public static Item STICK_C;
    public static Timer EM_LIGHTS_TOGGLE;
    @Mod.Instance(value="scm")
    public static SCM INSTANCE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        Config.initialize(event);
        LOGGER = event.getModLog();
        AUTOREG = new FCLRegistry.AutoRegisterer(MODID);
        GameRegistry.registerTileEntity(BlockBase.TileEntity.class, (ResourceLocation)new ResourceLocation("scm:blockbase"));
        GameRegistry.registerTileEntity(BlockBase.TextTileEntity.class, (ResourceLocation)new ResourceLocation("scm:blockbase_text"));
        SCMBlocks.register();
        if (FillerUtil.ENABLED) {
            Static.stop();
        }
        STICK_A = new StickItem(event, 0);
        AUTOREG.addItem("stick_a", STICK_A, 0, null);
        STICK_B = new StickItem(event, 1);
        AUTOREG.addItem("stick_b", STICK_B, 0, null);
        STICK_C = new StickItem(event, 2);
        AUTOREG.addItem("stick_c", STICK_C, 0, null);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (EM_LIGHTS_TOGGLE == null) {
            LocalDateTime midnight = LocalDateTime.of(LocalDate.now(ZoneOffset.systemDefault()), LocalTime.MIDNIGHT);
            long mid = midnight.toInstant(ZoneOffset.UTC).toEpochMilli();
            long date = Time.getDate();
            while ((mid += (long)Config.EM_LIGHTS_SPEED) < date) {
            }
            EM_LIGHTS_TOGGLE = new Timer();
            EM_LIGHTS_TOGGLE.schedule(new TimerTask(){

                @Override
                public void run() {
                    Config.EM_LIGHTS_STATE = !Config.EM_LIGHTS_STATE;
                }
            }, new Date(mid), (long)Config.EM_LIGHTS_SPEED);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SimpleUpdateHandler.register((String)MODID, (int)1, (String)VERSION);
        SimpleUpdateHandler.setUpdateMessage((String)MODID, (String)("&0[&5SCM&0] &7New Version available! &0(&8" + SimpleUpdateHandler.getLatestVersionOf((String)MODID) + "&0)"));
    }

    public static class StickItem
    extends Item {
        private int index;

        public StickItem(FMLPreInitializationEvent event, int i) {
            this.func_77625_d(1);
            this.index = i;
            if (event.getSide().isClient()) {
                this.func_77637_a(CreativeTabs.field_78040_i);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            switch (this.index) {
                case 0: {
                    tooltip.add("Right-Click on a vehicle to toggle head or tail lights.");
                    break;
                }
                case 1: {
                    tooltip.add("Right-Click on a vehicle to toggle emergency lights.");
                    break;
                }
                case 2: {
                    tooltip.add("Right-Click on an autobus to edit the text.");
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

