/*
 * Decompiled with CFR 0.152.
 */
package saracalia.scm.blocks;

import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.mc.api.packet.IPacketReceiver;
import net.fexcraft.lib.mc.network.packet.PacketTileEntityUpdate;
import net.fexcraft.lib.mc.registry.FCLRegistry;
import net.fexcraft.lib.mc.utils.ApiUtil;
import net.fexcraft.lib.mc.utils.Print;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import saracalia.scm.SCM;
import saracalia.scm.blocks.BlockItem;
import saracalia.scm.models.Model;

public abstract class BlockBase
extends Block
implements ITileEntityProvider {
    public final ResourceLocation texture;
    private String model;
    private String name;
    public final boolean hastext;

    public BlockBase(String name, String model, boolean hastext) {
        super(Material.field_151573_f);
        this.name = name;
        SCM.AUTOREG.addBlock(this.name, (Block)this, BlockItem.class, 0, null);
        this.model = model;
        this.texture = new ResourceLocation("scm:textures/blocks/" + this.name + ".png");
        this.hastext = hastext;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable net.minecraft.tileentity.TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(world, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            this.harvesters.set(player);
        }
        EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        item.func_92058_a(new ItemStack((Block)this));
        world.func_72838_d((Entity)item);
        this.harvesters.set(null);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (player.func_70093_af()) {
            return true;
        }
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b()) {
            return true;
        }
        TileEntity tile = (TileEntity)world.func_175625_s(pos);
        if (tile == null) {
            return true;
        }
        if (held.func_77973_b() instanceof ItemDye) {
            RGB colour = new RGB(ItemDye.field_150922_c[held.func_77960_j()]);
            held.func_190918_g(1);
            tile.setColor(colour);
            tile.updateClient();
            Print.chat((ICommandSender)player, (String)"&eColour applied.");
            return true;
        }
        if (held.func_77973_b() == SCM.STICK_A) {
            if (!tile.tail && !tile.head) {
                Print.bar((EntityPlayer)player, (String)"&eTail lights toggled!");
                tile.tail = true;
                tile.head = false;
                tile.updateClient();
            } else if (tile.tail && !tile.head) {
                Print.bar((EntityPlayer)player, (String)"&eHead lights toggled!");
                tile.tail = true;
                tile.head = true;
                tile.updateClient();
            } else if (tile.head) {
                Print.bar((EntityPlayer)player, (String)"&eLights toggled off!");
                tile.tail = false;
                tile.head = false;
                tile.updateClient();
            }
            return true;
        }
        if (held.func_77973_b() == SCM.STICK_B) {
            tile.emergency = !tile.emergency;
            Print.bar((EntityPlayer)player, (String)("&9EmergencyLights toggled " + (tile.emergency ? "&aon" : "&coff") + "&9!"));
            tile.updateClient();
            return true;
        }
        if (held.func_77973_b() == SCM.STICK_C) {
            if (!this.hastext) {
                Print.bar((EntityPlayer)player, (String)"This Block has no modificable text!");
                return true;
            }
            player.openGui((Object)SCM.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return this.hastext ? new TextTileEntity(this) : new TileEntity(this);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public abstract double getRotationForMeta(int var1);

    public static class TextTileEntity
    extends TileEntity
    implements IPacketReceiver<PacketTileEntityUpdate> {
        private String text;

        public TextTileEntity(BlockBase type) {
            super(type);
        }

        public TextTileEntity() {
        }

        public void setText(String text) {
            this.text = text;
            this.updateClient();
        }

        @Override
        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            super.func_145839_a(pkt.func_148857_g());
            this.func_145839_a(pkt.func_148857_g());
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            if (this.text != null) {
                compound.func_74778_a("scm:text", this.text);
            }
            return compound;
        }

        @Override
        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            if (compound.func_74764_b("scm:text")) {
                this.text = compound.func_74779_i("scm:text");
            }
        }

        @Override
        public String getText() {
            return this.text == null ? "no text set" : this.text;
        }
    }

    public static class TileEntity
    extends net.minecraft.tileentity.TileEntity
    implements IPacketReceiver<PacketTileEntityUpdate> {
        public BlockBase block;
        @SideOnly(value=Side.CLIENT)
        public Model.OldBase model;
        public RGB color;
        public boolean tail;
        public boolean head;
        public boolean emergency;
        public Boolean emergency_rand;

        public TileEntity(BlockBase type) {
            this.block = type;
        }

        public TileEntity() {
        }

        public void setColor(RGB colour) {
            this.color = colour;
        }

        public final void updateClient() {
            ApiUtil.sendTileEntityUpdatePacket((World)this.field_145850_b, (BlockPos)this.field_174879_c, (NBTTagCompound)this.func_189517_E_());
        }

        public final void processClientPacket(PacketTileEntityUpdate pkt) {
            this.func_145839_a(pkt.nbt);
        }

        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
        }

        public NBTTagCompound func_189517_E_() {
            return this.func_189515_b(new NBTTagCompound());
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            super.func_145839_a(pkt.func_148857_g());
            this.func_145839_a(pkt.func_148857_g());
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            if (this.tail) {
                compound.func_74757_a("scm:tail_lights", this.tail);
            }
            if (this.head) {
                compound.func_74757_a("scm:head_lights", this.head);
            }
            if (this.emergency) {
                compound.func_74757_a("scm:emergency_lights", this.emergency);
            }
            return compound;
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                this.loadClientData();
            }
            this.tail = compound.func_74764_b("scm:tail_lights") ? compound.func_74767_n("scm:tail_lights") : false;
            this.head = compound.func_74764_b("scm:head_lights") ? compound.func_74767_n("scm:head_lights") : false;
            this.emergency = compound.func_74764_b("scm:emergency_lights") ? compound.func_74767_n("scm:emergency_lights") : false;
        }

        public void loadClientData() {
            this.block = (BlockBase)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            this.model = (Model.OldBase)FCLRegistry.getModel((String)this.block.model.replace("scm:", "scm:models/block/"));
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return super.func_145833_n() * 8.0;
        }

        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getRenderBoundingBox() {
            return INFINITE_EXTENT_AABB;
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
            return oldState.func_177230_c() != newState.func_177230_c();
        }

        public String getText() {
            return "";
        }
    }
}

