/*
 * Decompiled with CFR 0.152.
 */
package saracalia.scm.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Scanner;
import net.fexcraft.lib.common.json.JsonUtil;
import net.fexcraft.lib.mc.registry.FCLRegistry;
import net.fexcraft.lib.mc.render.FCLItemModel;
import net.fexcraft.lib.mc.render.FCLItemModelLoader;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import saracalia.scm.blocks.SCMBlocks;
import saracalia.scm.models.Model;

public class FillerUtil {
    public static boolean ENABLED = false;
    private static File root;
    private static File lang;

    public static final void checkItemJson(String name) {
        File json;
        if (!ENABLED) {
            return;
        }
        if (root == null) {
            root = new File("./").getAbsoluteFile().getParentFile().getParentFile();
        }
        if (!(json = new File(root, "/src/main/resources/assets/scm/models/item/" + name + ".json")).exists()) {
            if (!json.getParentFile().exists()) {
                json.getParentFile().mkdirs();
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "scm:items/" + name);
            obj.add("textures", (JsonElement)textures);
            obj.addProperty("__comment", "Autogenerated Item JSON via SCM UTILS.");
            JsonUtil.write((File)json, (JsonElement)obj);
        }
    }

    public static final void checkLangFile(String name) {
        String regname;
        if (!ENABLED) {
            return;
        }
        if (lang == null) {
            lang = new File(root, "/src/main/resources/assets/scm/lang/en_us.lang");
        }
        if (!FillerUtil.containsLangEntry(regname = "tile.scm:" + name + ".name=")) {
            try {
                Files.write(lang.toPath(), ("\n" + regname).getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static final boolean containsLangEntry(String regname) {
        try {
            Scanner scanner = new Scanner(lang);
            while (scanner.hasNext()) {
                if (!scanner.nextLine().startsWith(regname)) continue;
                return true;
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcon(String name, String model_id) {
        Model model = (Model)FCLRegistry.getModel((String)model_id);
        FCLItemModelLoader.addItemModel((ResourceLocation)new ResourceLocation("scm", "models/block/" + name), (FCLItemModel)model);
    }

    public static void checkBlockState(SCMBlocks.Type type, String name, String model) {
        if (!ENABLED || type.isTEBased()) {
            return;
        }
        File json = new File(root, "/src/main/resources/assets/scm/blockstates/" + name + ".json");
        if (!json.exists()) {
            if (!json.getParentFile().exists()) {
                json.getParentFile().mkdirs();
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("forge_marker", (Number)1);
            JsonObject defs = new JsonObject();
            defs.addProperty("model", model);
            defs.addProperty("transform", "forge:default-block");
            JsonObject custom = new JsonObject();
            custom.addProperty("t-x", (Number)0.5);
            custom.addProperty("t-z", (Number)0.5);
            custom.addProperty("texture", name);
            defs.add("custom", (JsonElement)custom);
            obj.add("defaults", (JsonElement)defs);
            JsonObject vars = new JsonObject();
            switch (type) {
                case ROT_16: {
                    JsonObject rotation = new JsonObject();
                    for (int i = 0; i < 16; ++i) {
                        JsonObject rot = new JsonObject();
                        custom = new JsonObject();
                        custom.addProperty("y", (Number)(-90.0 + (double)i * 22.5));
                        rot.add("custom", (JsonElement)custom);
                        rotation.add(i + "", (JsonElement)rot);
                    }
                    vars.add("rotation", (JsonElement)rotation);
                    break;
                }
                case ROT_4: {
                    JsonObject facing = new JsonObject();
                    for (int i = 2; i < 6; ++i) {
                        EnumFacing ef = EnumFacing.func_82600_a((int)i);
                        JsonObject efo = new JsonObject();
                        custom = new JsonObject();
                        custom.addProperty("y", (Number)(i == 2 ? 90 : (i == 3 ? -90 : (i == 4 ? 0 : 180))));
                        efo.add("custom", (JsonElement)custom);
                        facing.add(ef.func_176610_l(), (JsonElement)efo);
                    }
                    vars.add("facing", (JsonElement)facing);
                    break;
                }
                case LIGHT: {
                    JsonArray array = new JsonArray();
                    array.add((JsonElement)new JsonObject());
                    vars.add("normal", (JsonElement)array);
                }
            }
            obj.add("variants", (JsonElement)vars);
            obj.addProperty("__comment", "Autogenerated Item JSON via SCM UTILS.");
            JsonUtil.write((File)json, (JsonElement)obj);
        }
    }
}

