/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.lang;

import java.util.ArrayList;
import java.util.Collection;
import net.fexcraft.lib.common.utils.Print;

public class LimitedList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SIZE_LIMIT = 10;
    private int maxsize;

    public LimitedList() {
        this(10);
    }

    public LimitedList(int size) {
        this.maxsize = size;
    }

    @Override
    public boolean add(E object) {
        return this.size() + 1 > this.maxsize ? Print.bool(false, "Array limit reached.") : this.add(object);
    }

    @Override
    public void add(int index, E element) {
        if (this.size() + 1 > this.maxsize) {
            Print.console("Array limit reached.");
            return;
        }
        this.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        return this.size() + coll.size() > this.maxsize ? Print.bool(false, "Array limit reached.") : this.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        return this.size() + coll.size() > this.maxsize ? Print.bool(false, "Array limit reached.") : this.addAll(index, coll);
    }

    public int maxSize() {
        return this.maxsize;
    }
}

