/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.fexcraft.lib.common.Static;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class RGB {
    public int packed = 0;
    public float alpha = 1.0f;
    public static final RGB RED = new RGB(255, 0, 0);
    public static final RGB GREEN = new RGB(0, 255, 0);
    public static final RGB BLUE = new RGB(0, 0, 255);
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    private static final DecimalFormat df = new DecimalFormat("##.#####");

    public RGB() {
        this.packed = RGB.WHITE.packed;
        this.alpha = RGB.WHITE.alpha;
    }

    public RGB(RGB rgb) {
        this.packed = rgb.packed;
        this.alpha = rgb.alpha;
    }

    public RGB(int color) {
        this.packed = color;
    }

    public RGB(byte r, byte g, byte b) {
        this.packed = 65536 * (r + 128) + 256 * (g + 128) + (b + 128);
    }

    public RGB(byte i, byte j, byte k, float f) {
        this(i, j, k);
        this.alpha = f;
    }

    public RGB(int r, int g, int b) {
        int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
        int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
        b = b > 255 ? 255 : (b < 0 ? 0 : b);
        this.packed = 65536 * r + 256 * g + b;
    }

    public RGB(int r, int g, int b, float a) {
        this(r, g, b);
        this.alpha = a;
    }

    public RGB(byte[] i) {
        this(i.length >= 1 ? i[0] : (byte)0, i.length >= 2 ? i[1] : (byte)0, i.length >= 3 ? i[2] : (byte)0);
        if (i.length >= 4) {
            this.alpha = i[3] / 255;
        }
    }

    public RGB(int[] i) {
        this(i.length >= 1 ? i[0] : 0, i.length >= 2 ? i[1] : 0, i.length >= 3 ? i[2] : 0);
        if (i.length >= 4) {
            this.alpha = i[3] / 255;
        }
    }

    public RGB(String hex) {
        this(Integer.parseInt(hex.replace("#", ""), 16));
    }

    public RGB(String hex, float alpha) {
        this(hex);
        this.alpha = alpha;
    }

    public static RGB fromStrings(String x, String y, String z) {
        try {
            int r = Integer.parseInt(x);
            int g = Integer.parseInt(y);
            int b = Integer.parseInt(z);
            return new RGB(r, g, b);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RGB(WHITE);
        }
    }

    public static RGB fromStrings(String[] s) {
        switch (s.length) {
            case 0: {
                return new RGB(WHITE);
            }
            case 1: {
                return RGB.fromStrings(s[0], "255", "255");
            }
            case 2: {
                return RGB.fromStrings(s[0], s[1], "255");
            }
        }
        return RGB.fromStrings(s[0], s[1], s[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public void glColorApply() {
        GL11.glColor4f((float)((float)(this.packed >> 16 & 0xFF) / 255.0f), (float)((float)(this.packed >> 8 & 0xFF) / 255.0f), (float)((float)(this.packed & 0xFF) / 255.0f), (float)this.alpha);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void glColorReset() {
        GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
    }

    public static final RGB fromDyeColor(EnumDyeColor e) {
        return new RGB(RGB.get(e));
    }

    private static final int get(EnumDyeColor e) {
        switch (e) {
            case WHITE: {
                return 0xF9FFFE;
            }
            case ORANGE: {
                return 16351261;
            }
            case MAGENTA: {
                return 13061821;
            }
            case LIGHT_BLUE: {
                return 3847130;
            }
            case YELLOW: {
                return 16701501;
            }
            case LIME: {
                return 8439583;
            }
            case PINK: {
                return 15961002;
            }
            case GRAY: {
                return 4673362;
            }
            case SILVER: {
                return 0x9D9D97;
            }
            case CYAN: {
                return 1481884;
            }
            case PURPLE: {
                return 8991416;
            }
            case BLUE: {
                return 3949738;
            }
            case BROWN: {
                return 8606770;
            }
            case GREEN: {
                return 6192150;
            }
            case RED: {
                return 11546150;
            }
        }
        return 0x1D1D21;
    }

    public final String toString() {
        return Integer.toHexString(this.packed);
    }

    public final int getColorInt() {
        return this.packed;
    }

    public float[] toFloatArray() {
        return new float[]{(float)(this.packed >> 16 & 0xFF) / 255.0f, (float)(this.packed >> 8 & 0xFF) / 255.0f, (float)(this.packed & 0xFF) / 255.0f, this.alpha};
    }

    public byte[] toByteArray() {
        return new byte[]{(byte)((this.packed >> 16 & 0xFF) - 128), (byte)((this.packed >> 8 & 0xFF) - 128), (byte)((this.packed & 0xFF) - 128)};
    }

    public RGB(JsonElement object) {
        this(object, false);
    }

    public RGB(JsonElement elm, boolean write) {
        if (!(!elm.isJsonPrimitive() && elm.isJsonObject() || elm.isJsonArray())) {
            try {
                this.packed = Integer.parseInt(elm.getAsString(), 16);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.packed = Integer.parseInt(elm.getAsString(), 10);
            }
            return;
        }
        JsonObject object = elm.getAsJsonObject();
        String[] red = new String[]{"Red", "red", "r", "R"};
        String[] blue = new String[]{"Blue", "blue", "b", "B"};
        String[] green = new String[]{"Green", "green", "g", "G"};
        byte r = RGB.getFJO(red, object, write, this.packed);
        byte b = RGB.getFJO(blue, object, write, this.packed);
        byte g = RGB.getFJO(green, object, write, this.packed);
        this.packed = new RGB((byte)r, (byte)g, (byte)b).packed;
    }

    private static final byte getFJO(String[] strings, JsonObject obj, boolean write, int packed) {
        for (String s : strings) {
            if (!obj.has(s)) continue;
            int j = obj.get(s).getAsInt() - 128;
            return (byte)(j > 127 ? 127 : (j < -128 ? -128 : j));
        }
        if (write) {
            obj.addProperty("RGB", (Number)packed);
        }
        return 0;
    }

    public static String format(double d) {
        return df.format(d);
    }

    public static RGB random() {
        return new RGB(Static.random.nextInt(RGB.WHITE.packed));
    }

    public RGB setAlpha(float value) {
        this.alpha = value;
        return this;
    }

    public RGB copy() {
        return new RGB(this);
    }

    static {
        df.setRoundingMode(RoundingMode.DOWN);
    }
}

