/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import org.lwjgl.opengl.GL11;

public class TexturedPolygon {
    private boolean invert;
    private float[] normals;
    private RGB color = null;
    private ArrayList<Vec3f> list;
    private TexturedVertex[] vertices;

    public TexturedPolygon(TexturedVertex[] verts) {
        this.vertices = verts;
        this.invert = false;
        this.normals = new float[0];
        this.list = new ArrayList();
    }

    public void setInvert(boolean bool) {
        this.invert = bool;
    }

    public void setNormals(float x, float y, float z) {
        this.normals = new float[]{x, y, z};
    }

    public void setNormals(ArrayList<Vec3f> normallist) {
        this.list = normallist;
    }

    public void draw(float scale, RGB lincol, RGB rgb) {
        if (lincol != null) {
            GL11.glBegin((int)3);
            lincol.glColorApply();
        } else {
            switch (this.vertices.length) {
                case 3: {
                    GL11.glBegin((int)4);
                    break;
                }
                case 4: {
                    GL11.glBegin((int)7);
                    break;
                }
                default: {
                    GL11.glBegin((int)9);
                }
            }
        }
        if (this.list.isEmpty()) {
            if (this.normals.length == 3) {
                if (this.invert) {
                    GL11.glNormal3f((float)(-this.normals[0]), (float)(-this.normals[1]), (float)(-this.normals[2]));
                } else {
                    GL11.glNormal3f((float)this.normals[0], (float)this.normals[1], (float)this.normals[2]);
                }
            } else if (this.vertices.length >= 3) {
                Vec3f vec0 = new Vec3f(this.vertices[1].vector.subtract(this.vertices[0].vector));
                Vec3f vec1 = new Vec3f(this.vertices[1].vector.subtract(this.vertices[2].vector));
                Vec3f vec2 = vec1.crossProduct(vec0).normalize();
                if (this.invert) {
                    GL11.glNormal3f((float)(-vec2.xCoord), (float)(-vec2.yCoord), (float)(-vec2.zCoord));
                } else {
                    GL11.glNormal3f((float)vec2.xCoord, (float)vec2.yCoord, (float)vec2.zCoord);
                }
            } else {
                return;
            }
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            TexturedVertex texvex = this.vertices[i];
            if (i < this.list.size()) {
                if (this.invert) {
                    GL11.glNormal3f((float)(-this.list.get((int)i).xCoord), (float)(-this.list.get((int)i).yCoord), (float)(-this.list.get((int)i).zCoord));
                } else {
                    GL11.glNormal3f((float)this.list.get((int)i).xCoord, (float)this.list.get((int)i).yCoord, (float)this.list.get((int)i).zCoord);
                }
            }
            if (rgb == null && this.color == null) {
                GL11.glTexCoord2f((float)texvex.textureX, (float)texvex.textureY);
                GL11.glVertex3f((float)(texvex.vector.xCoord * scale), (float)(texvex.vector.yCoord * scale), (float)(texvex.vector.zCoord * scale));
                continue;
            }
            (this.color == null ? rgb : this.color).glColorApply();
            GL11.glVertex3f((float)(texvex.vector.xCoord * scale), (float)(texvex.vector.yCoord * scale), (float)(texvex.vector.zCoord * scale));
        }
        GL11.glEnd();
    }

    public void flipFace() {
        TexturedVertex[] tva = new TexturedVertex[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            tva[i] = this.vertices[this.vertices.length - i - 1];
        }
        this.vertices = tva;
    }

    public TexturedVertex[] getVertices() {
        return this.vertices;
    }

    public void clearNormals() {
        this.normals = new float[0];
        this.list = new ArrayList();
    }

    public boolean isInverted() {
        return this.invert;
    }

    public float[] getNormals() {
        return this.normals;
    }

    public List<Vec3f> getVectors() {
        return this.list;
    }

    public TexturedPolygon setColor(RGB rgb) {
        this.color = rgb;
        return this;
    }
}

