/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import javax.annotation.Nullable;

public class Vec3f {
    public float xCoord;
    public float yCoord;
    public float zCoord;

    public Vec3f() {
        this.zCoord = 0.0f;
        this.yCoord = 0.0f;
        this.xCoord = 0.0f;
    }

    public Vec3f(float x, float y, float z) {
        if (x == -0.0f) {
            x = 0.0f;
        }
        if (y == -0.0f) {
            y = 0.0f;
        }
        if (z == -0.0f) {
            z = 0.0f;
        }
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public Vec3f(Vec3f vector) {
        this(vector.xCoord, vector.yCoord, vector.zCoord);
    }

    public Vec3f(double xVec, double yVec, double zVec) {
        this((float)xVec, (float)yVec, (float)zVec);
    }

    public Vec3f subtractReverse(Vec3f vec) {
        return new Vec3f(vec.xCoord - this.xCoord, vec.yCoord - this.yCoord, vec.zCoord - this.zCoord);
    }

    public Vec3f normalize() {
        double d0 = Math.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
        return d0 < 1.0E-4 ? new Vec3f() : new Vec3f((double)this.xCoord / d0, (double)this.yCoord / d0, (double)this.zCoord / d0);
    }

    public float dotProduct(Vec3f vec) {
        return this.xCoord * vec.xCoord + this.yCoord * vec.yCoord + this.zCoord * vec.zCoord;
    }

    public Vec3f crossProduct(Vec3f vec) {
        return new Vec3f(this.yCoord * vec.zCoord - this.zCoord * vec.yCoord, this.zCoord * vec.xCoord - this.xCoord * vec.zCoord, this.xCoord * vec.yCoord - this.yCoord * vec.xCoord);
    }

    public Vec3f subtract(Vec3f vec) {
        return this.subtract(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    public Vec3f subtract(float x, float y, float z) {
        return this.addVector(-x, -y, -z);
    }

    public Vec3f add(Vec3f vec) {
        return this.addVector(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    public Vec3f addVector(float x, float y, float z) {
        return new Vec3f(this.xCoord + x, this.yCoord + y, this.zCoord + z);
    }

    public float distanceTo(Vec3f vec) {
        float d0 = vec.xCoord - this.xCoord;
        float d1 = vec.yCoord - this.yCoord;
        float d2 = vec.zCoord - this.zCoord;
        return (float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public float squareDistanceTo(Vec3f vec) {
        float d0 = vec.xCoord - this.xCoord;
        float d1 = vec.yCoord - this.yCoord;
        float d2 = vec.zCoord - this.zCoord;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public float squareDistanceTo(float xIn, float yIn, float zIn) {
        float d0 = xIn - this.xCoord;
        float d1 = yIn - this.yCoord;
        float d2 = zIn - this.zCoord;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public Vec3f scale(float scale) {
        return new Vec3f(this.xCoord * scale, this.yCoord * scale, this.zCoord * scale);
    }

    public float lengthVector() {
        return (float)Math.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
    }

    public float lengthSquared() {
        return this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord;
    }

    @Nullable
    public Vec3f getIntermediateWithXValue(Vec3f vec, float x) {
        float d0 = vec.xCoord - this.xCoord;
        float d1 = vec.yCoord - this.yCoord;
        float d2 = vec.zCoord - this.zCoord;
        if ((double)(d0 * d0) < (double)1.0E-7f) {
            return null;
        }
        float d3 = (x - this.xCoord) / d0;
        return d3 >= 0.0f && d3 <= 1.0f ? new Vec3f(this.xCoord + d0 * d3, this.yCoord + d1 * d3, this.zCoord + d2 * d3) : null;
    }

    @Nullable
    public Vec3f getIntermediateWithYValue(Vec3f vec, float y) {
        float d0 = vec.xCoord - this.xCoord;
        float d1 = vec.yCoord - this.yCoord;
        float d2 = vec.zCoord - this.zCoord;
        if ((double)(d1 * d1) < (double)1.0E-7f) {
            return null;
        }
        float d3 = (y - this.yCoord) / d1;
        return d3 >= 0.0f && d3 <= 1.0f ? new Vec3f(this.xCoord + d0 * d3, this.yCoord + d1 * d3, this.zCoord + d2 * d3) : null;
    }

    @Nullable
    public Vec3f getIntermediateWithZValue(Vec3f vec, float z) {
        float d0 = vec.xCoord - this.xCoord;
        float d1 = vec.yCoord - this.yCoord;
        float d2 = vec.zCoord - this.zCoord;
        if ((double)(d2 * d2) < (double)1.0E-7f) {
            return null;
        }
        float d3 = (z - this.zCoord) / d2;
        return d3 >= 0.0f && d3 <= 1.0f ? new Vec3f(this.xCoord + d0 * d3, this.yCoord + d1 * d3, this.zCoord + d2 * d3) : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vec3f)) {
            return false;
        }
        Vec3f vec3d = (Vec3f)obj;
        return Float.compare(vec3d.xCoord, this.xCoord) != 0 ? false : (Float.compare(vec3d.yCoord, this.yCoord) != 0 ? false : Float.compare(vec3d.zCoord, this.zCoord) == 0);
    }

    public int hashCode() {
        long j = Float.floatToIntBits(this.xCoord);
        int i = (int)(j ^ j >>> 32);
        j = Float.floatToIntBits(this.yCoord);
        i = 31 * i + (int)(j ^ j >>> 32);
        j = Float.floatToIntBits(this.zCoord);
        i = 31 * i + (int)(j ^ j >>> 32);
        return i;
    }

    public String toString() {
        return String.format("Vec3f[ %s, %s, %s ]", Float.valueOf(this.xCoord), Float.valueOf(this.yCoord), Float.valueOf(this.zCoord));
    }

    public Vec3f middle(Vec3f target) {
        return new Vec3f((double)(this.xCoord + target.xCoord) * 0.5, (double)(this.yCoord + target.yCoord) * 0.5, (double)(this.zCoord + target.zCoord) * 0.5);
    }

    public Vec3f distance(Vec3f dest, float am) {
        Vec3f vec = new Vec3f((double)(this.xCoord + dest.xCoord) * 0.5, (double)(this.yCoord + dest.yCoord) * 0.5, (double)(this.zCoord + dest.zCoord) * 0.5);
        vec = Vec3f.direction(vec.xCoord - this.xCoord, vec.yCoord - this.yCoord, vec.zCoord - this.zCoord);
        return new Vec3f(this.xCoord + vec.xCoord * am, this.yCoord + vec.yCoord * am, this.zCoord + vec.zCoord * am);
    }

    public double length() {
        return Math.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
    }

    public static double length(float ... arr) {
        return Math.sqrt(arr[0] * arr[0] + arr[1] * arr[1] + arr[2] * arr[2]);
    }

    public static double length(Vec3f vec) {
        return Math.sqrt(vec.xCoord * vec.xCoord + vec.yCoord * vec.yCoord + vec.zCoord * vec.zCoord);
    }

    public static Vec3f direction(float ... arr) {
        double l = Vec3f.length(arr[0], arr[1], arr[2]);
        return new Vec3f((double)arr[0] / l, (double)arr[1] / l, (double)arr[2] / l);
    }

    public static Vec3f direction(Vec3f vec) {
        double l = Vec3f.length(vec.xCoord, vec.yCoord, vec.zCoord);
        return new Vec3f((double)vec.xCoord / l, (double)vec.yCoord / l, (double)vec.zCoord / l);
    }

    public Vec3f cross(Vec3f other) {
        return new Vec3f(this.yCoord * other.zCoord - this.zCoord * other.yCoord, other.xCoord * this.zCoord - other.zCoord * this.xCoord, this.xCoord * other.yCoord - this.yCoord * other.xCoord);
    }

    public float dot(Vec3f other) {
        return this.xCoord * other.xCoord + this.yCoord * other.yCoord + this.zCoord * other.zCoord;
    }

    public Vec3f normalize(Vec3f dest) {
        float len = (float)this.length();
        return dest == null ? new Vec3f(this.xCoord / len, this.yCoord / len, this.zCoord / len) : dest.set(this.xCoord / len, this.yCoord / len, this.zCoord / len);
    }

    private Vec3f set(float f, float g, float h) {
        this.xCoord = f;
        this.yCoord = g;
        this.zCoord = h;
        return this;
    }

    public float[] toFloatArray() {
        return new float[]{this.xCoord, this.yCoord, this.zCoord};
    }

    public double[] toDoubleArray() {
        return new double[]{this.xCoord, this.yCoord, this.zCoord};
    }

    public void copyFrom(Vec3f pos) {
        this.xCoord = pos.xCoord;
        this.yCoord = pos.yCoord;
        this.zCoord = pos.zCoord;
    }

    public boolean isNull() {
        return this.xCoord == 0.0f && this.yCoord == 0.0f && this.zCoord == 0.0f;
    }
}

