/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.DataOutputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.fexcraft.lib.common.json.JsonUtil;
import sun.net.www.protocol.https.Handler;

public class HttpsUtil {
    private static SSLSocketFactory temp_off;
    private static SSLSocketFactory old;

    public static JsonObject request(String adress, String parameters, String[] cookies, int timeout) {
        try {
            URL url = new URL(null, adress, new Handler());
            old = HttpsURLConnection.getDefaultSSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(temp_off);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            if (cookies != null && cookies.length > 0) {
                String str = "";
                for (int i = 0; i < cookies.length; ++i) {
                    str = str + cookies[i];
                    if (i == cookies.length - 1) continue;
                    str = str + "; ";
                }
                connection.setRequestProperty("Cookie", str);
            }
            connection.setConnectTimeout(timeout);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(parameters);
            wr.flush();
            wr.close();
            JsonObject cook = new JsonObject();
            int i = 0;
            while (true) {
                String name = connection.getHeaderFieldKey(i);
                String val = connection.getHeaderField(i);
                if (name == null && val == null) break;
                if ("Set-Cookie".equalsIgnoreCase(name)) {
                    String[] fields;
                    for (String str : fields = val.split(";\\s*")) {
                        String[] split = str.split("=");
                        if (split.length < 2) continue;
                        cook.addProperty(split[0], split[1]);
                    }
                }
                ++i;
            }
            JsonObject obj = JsonUtil.getObjectFromInputStream(connection.getInputStream());
            if (cook.entrySet().size() > 0) {
                obj.add(obj.has("cookies") ? "%http:cookies%" : "cookies", (JsonElement)cook);
            }
            connection.disconnect();
            HttpsURLConnection.setDefaultSSLSocketFactory(old);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (old != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(old);
            }
            return null;
        }
    }

    public static JsonObject request(String adress, String parameters) {
        return HttpsUtil.request(adress, parameters, null, 5000);
    }

    public static JsonObject request(String adress, String parameters, int timeout) {
        return HttpsUtil.request(adress, parameters, null, timeout);
    }

    public static JsonObject request(String adress, String parameters, String[] cookies) {
        return HttpsUtil.request(adress, parameters, cookies, 5000);
    }

    public static JsonElement request(String adress, String[] cookies) {
        return HttpsUtil.request(adress, cookies, 5000);
    }

    public static JsonElement request(String adress, String[] cookies, int timeout) {
        try {
            int i;
            URL url = new URL(null, adress, new Handler());
            old = HttpsURLConnection.getDefaultSSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(temp_off);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            if (cookies != null && cookies.length > 0) {
                String str = "";
                for (i = 0; i < cookies.length; ++i) {
                    str = str + cookies[i];
                    if (i == cookies.length - 1) continue;
                    str = str + "; ";
                }
                connection.setRequestProperty("Cookie", str);
            }
            connection.setConnectTimeout(timeout);
            JsonObject cook = new JsonObject();
            i = 0;
            while (true) {
                String name = connection.getHeaderFieldKey(i);
                String val = connection.getHeaderField(i);
                if (name == null && val == null) break;
                if ("Set-Cookie".equalsIgnoreCase(name)) {
                    String[] fields;
                    for (String str : fields = val.split(";\\s*")) {
                        String[] split = str.split("=");
                        if (split.length < 2) continue;
                        cook.addProperty(split[0], split[1]);
                    }
                }
                ++i;
            }
            JsonElement obj = JsonUtil.getElementFromInputStream(connection.getInputStream());
            if (obj.isJsonObject() && cook.entrySet().size() > 0) {
                obj.getAsJsonObject().add(obj.getAsJsonObject().has("cookies") ? "%http:cookies%" : "cookies", (JsonElement)cook);
            }
            connection.disconnect();
            HttpsURLConnection.setDefaultSSLSocketFactory(old);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (old != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(old);
            }
            return null;
        }
    }

    public static JsonElement request(String adress) {
        return HttpsUtil.request(adress, (String[])null);
    }

    static {
        try {
            TrustManager[] temp_toggle_off = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, temp_toggle_off, new SecureRandom());
            temp_off = sc.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }
}

