/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;

public class WavefrontObjUtil {
    public static String[] getGroups(File objfile) {
        try {
            return WavefrontObjUtil.getGroups(new FileInputStream(objfile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public static String[] getGroups(InputStream stream) {
        ArrayList<String> arr = new ArrayList<String>();
        try {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() == 0 || !s.startsWith("g ")) continue;
                arr.add(s.replace("g ", "").split(" ")[0]);
            }
            in.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Static.stop();
        }
        return arr.toArray(new String[0]);
    }

    public static String[] getObjects(InputStream stream) {
        ArrayList<String> arr = new ArrayList<String>();
        try {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() == 0 || !s.startsWith("o ")) continue;
                arr.add(s.replace("o ", "").split(" ")[0]);
            }
            in.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Static.stop();
        }
        return arr.toArray(new String[0]);
    }

    public static String[][] findValues(InputStream stream, Integer limit, String key) {
        return WavefrontObjUtil.findValues(stream, limit, new String[]{key}, " ");
    }

    public static String[][] findValues(InputStream stream, Integer limit, String[] keys) {
        return WavefrontObjUtil.findValues(stream, limit, keys, " ");
    }

    public static String[][] findValues(InputStream stream, Integer limit, String[] keys, String divident) {
        return WavefrontObjUtil.findValues(stream, limit, keys, " ", null);
    }

    public static String[][] findValues(InputStream stream, Integer limit, String[] keys, String divident, String endat) {
        if (keys == null || keys.length == 0) {
            return new String[0][0];
        }
        if (divident == null) {
            divident = " ";
        }
        ArrayList<String[]> arr = new ArrayList<String[]>();
        Integer counter = limit == null || limit <= 0 ? null : limit;
        try {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((s = in.readLine()) != null && (counter == null || counter < limit)) {
                if ((s = s.trim()).length() == 0) continue;
                if (endat != null && s.startsWith(endat)) break;
                for (String str : keys) {
                    if (!s.startsWith(str + " ")) continue;
                    arr.add(s.replace(str + " ", "").split(divident));
                    if (counter == null) continue;
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                }
            }
            in.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Static.stop();
        }
        return (String[][])arr.toArray((T[])new String[0][]);
    }

    public static Object[][] getVerticesAndPolygons(InputStream stream, @Nullable String group, boolean flipaxes, boolean objmode) {
        TexturedVertex[] vertices = null;
        TexturedPolygon[] polygons = null;
        Boolean passing = null;
        String grouprefix = objmode ? "o " : "g ";
        ArrayList<TexturedVertex> verts0 = new ArrayList<TexturedVertex>();
        ArrayList verts1 = new ArrayList();
        ArrayList<TexturedPolygon> faces = new ArrayList<TexturedPolygon>();
        ArrayList<float[]> uvs = new ArrayList<float[]>();
        ArrayList<float[]> normals = new ArrayList<float[]>();
        try {
            int i;
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((s = in.readLine()) != null) {
                float[] v;
                if (s.contains("#")) {
                    s = s.substring(0, s.indexOf("#"));
                }
                if ((s = s.trim()).equals("")) continue;
                if (s.startsWith("v ")) {
                    s = s.substring(s.indexOf(" ") + 1).trim();
                    v = new float[3];
                    for (int i2 = 0; i2 < 3; ++i2) {
                        int ind = s.indexOf(" ");
                        v[i2] = ind > -1 ? Float.parseFloat(s.substring(0, ind)) : Float.parseFloat(s.substring(0));
                        s = s.substring(s.indexOf(" ") + 1).trim();
                    }
                    if (!flipaxes) {
                        verts0.add(new TexturedVertex(v[0], v[1], v[2], 0.0f, 0.0f));
                        continue;
                    }
                    verts0.add(new TexturedVertex(v[0], -v[2], v[1], 0.0f, 0.0f));
                    continue;
                }
                if (s.startsWith("vt ")) {
                    s = s.substring(s.indexOf(" ") + 1).trim();
                    v = new float[2];
                    for (int i3 = 0; i3 < 2; ++i3) {
                        int ind = s.indexOf(" ");
                        v[i3] = ind > -1 ? Float.parseFloat(s.substring(0, ind)) : Float.parseFloat(s.substring(0));
                        s = s.substring(s.indexOf(" ") + 1).trim();
                    }
                    uvs.add(new float[]{v[0] < 0.0f ? -v[0] : v[0], v[1] < 0.0f ? -v[1] : v[1]});
                    continue;
                }
                if (s.startsWith("vn ")) {
                    s = s.substring(s.indexOf(" ") + 1).trim();
                    v = new float[3];
                    for (int i4 = 0; i4 < 3; ++i4) {
                        int ind = s.indexOf(" ");
                        v[i4] = ind > -1 ? Float.parseFloat(s.substring(0, ind)) : Float.parseFloat(s.substring(0));
                        s = s.substring(s.indexOf(" ") + 1).trim();
                    }
                    float flt = v[2];
                    v[2] = v[1];
                    v[1] = flt;
                    normals.add(new float[]{v[0], v[1], v[2]});
                    continue;
                }
                if (s.startsWith(grouprefix) && group != null) {
                    passing = s.replace(grouprefix, "").split(" ")[0].equals(group);
                }
                if (passing != null && !passing.booleanValue() || !s.startsWith("f ")) continue;
                s = s.substring(s.indexOf(" ") + 1).trim();
                ArrayList<TexturedVertex> vc = new ArrayList<TexturedVertex>();
                int finalPhase = 0;
                float[] normal = new float[]{0.0f, 0.0f, 0.0f};
                ArrayList<Vec3f> iNormal = new ArrayList<Vec3f>();
                do {
                    float[] curNormals;
                    float[] curUV;
                    int vInt;
                    int ind = s.indexOf(" ");
                    String s1 = s;
                    if (ind > -1) {
                        s1 = s.substring(0, ind);
                    }
                    if (s1.indexOf("/") > -1) {
                        String[] f = s1.split("/");
                        vInt = Integer.parseInt(f[0]) - 1;
                        if (f[1].equals("")) {
                            f[1] = f[0];
                        }
                        int vtInt = Integer.parseInt(f[1]) - 1;
                        curUV = uvs.size() > vtInt ? (float[])uvs.get(vtInt) : new float[]{0.0f, 0.0f};
                        int vnInt = 0;
                        if (f.length == 3) {
                            if (f[2].equals("")) {
                                f[2] = f[0];
                            }
                            vnInt = Integer.parseInt(f[2]) - 1;
                        } else {
                            vnInt = Integer.parseInt(f[0]) - 1;
                        }
                        curNormals = normals.size() > vnInt ? (float[])normals.get(vnInt) : new float[]{0.0f, 0.0f, 0.0f};
                    } else {
                        vInt = Integer.parseInt(s1) - 1;
                        curUV = uvs.size() > vInt ? (float[])uvs.get(vInt) : new float[]{0.0f, 0.0f};
                        curNormals = normals.size() > vInt ? (float[])normals.get(vInt) : new float[]{0.0f, 0.0f, 0.0f};
                    }
                    iNormal.add(new Vec3f(curNormals[0], curNormals[1], curNormals[2]));
                    normal[0] = normal[0] + curNormals[0];
                    normal[1] = normal[1] + curNormals[1];
                    normal[2] = normal[2] + curNormals[2];
                    if (vInt < verts0.size()) {
                        vc.add(((TexturedVertex)verts0.get(vInt)).setTexturePosition(curUV[0], curUV[1]));
                    }
                    if (ind > -1) {
                        s = s.substring(s.indexOf(" ") + 1).trim();
                        continue;
                    }
                    ++finalPhase;
                } while (finalPhase < 1);
                float d = (float)Math.sqrt(normal[0] * normal[0] + normal[1] * normal[1] + normal[2] * normal[2]);
                normal[0] = normal[0] / d;
                normal[1] = normal[1] / d;
                normal[2] = normal[2] / d;
                TexturedVertex[] vToArr = new TexturedVertex[vc.size()];
                for (int i5 = 0; i5 < vc.size(); ++i5) {
                    vToArr[i5] = (TexturedVertex)vc.get(i5);
                }
                TexturedPolygon poly = new TexturedPolygon(vToArr);
                poly.setNormals(normal[0], normal[1], normal[2]);
                poly.setNormals(iNormal);
                faces.add(poly);
                verts1.addAll(vc);
            }
            vertices = new TexturedVertex[verts1.size()];
            for (i = 0; i < verts1.size(); ++i) {
                vertices[i] = (TexturedVertex)verts1.get(i);
            }
            polygons = new TexturedPolygon[faces.size()];
            for (i = 0; i < faces.size(); ++i) {
                polygons[i] = (TexturedPolygon)faces.get(i);
                polygons[i].clearNormals();
            }
            in.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Static.stop();
        }
        return new Object[][]{vertices, polygons};
    }
}

