/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.fexcraft.lib.mc.capabilities.paint.Paintable;
import net.fexcraft.lib.mc.capabilities.paint.PaintableSerializer;
import net.fexcraft.lib.mc.capabilities.sign.ExampleListener;
import net.fexcraft.lib.mc.capabilities.sign.SignCapability;
import net.fexcraft.lib.mc.capabilities.sign.SignCapabilitySerializer;
import net.fexcraft.lib.mc.gui.ClientReceiver;
import net.fexcraft.lib.mc.gui.GuiHandler;
import net.fexcraft.lib.mc.gui.ServerReceiver;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.SimpleUpdateHandler;
import net.fexcraft.lib.mc.network.handlers.NBTTagCompoundPacketHandler;
import net.fexcraft.lib.mc.registry.CreativeTab;
import net.fexcraft.lib.mc.registry.FCLRegistry;
import net.fexcraft.lib.mc.render.LoaderReg;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.mc.utils.Static;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="fcl", name="Fexcraft Common Library", version="1.12.56", acceptableRemoteVersions="*", acceptedMinecraftVersions="*", updateJSON="http://fexcraft.net/minecraft/fcl/request?mode=getForgeUpdateJson&modid=fcl")
public class FCL {
    public static final String prefix = TextFormatting.BLACK + "[" + TextFormatting.DARK_AQUA + "FCL" + TextFormatting.BLACK + "]" + TextFormatting.GRAY + " ";
    public static final String version = "1.12.56";
    public static final String mcv = "1.12.2";
    public static final UUID[] authors = new UUID[]{UUID.fromString("01e4af9b-2a30-471e-addf-f6338ffce04b")};
    @Mod.Instance(value="fcl")
    private static FCL instance;
    private static Side side;
    private static File configdir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        Static.setAsMcLib(true);
        Static.setDevmode((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment"));
        side = event.getSide();
        Static.setIsServer(side.isServer());
        configdir = new File(event.getSuggestedConfigurationFile().getParentFile(), "/fcl/");
        FCLRegistry.prepare(event.getSide(), event.getAsmData());
        if (event.getSide().isClient()) {
            LoaderReg.ister();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws Exception {
        MinecraftForge.EVENT_BUS.register((Object)new SimpleUpdateHandler.EventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLServerStartingEvent event) {
        FCLRegistry.registerCommands(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws Exception {
        SimpleUpdateHandler.register("fcl", 1, version);
        SimpleUpdateHandler.setUpdateMessage("fcl", prefix + "Update available! (" + SimpleUpdateHandler.getLatestVersionOf("fcl") + ")");
        SimpleUpdateHandler.postInit();
        FCLRegistry.clear(event);
        PacketHandler.init();
        CreativeTab.getIcons();
        MinecraftForge.EVENT_BUS.register((Object)new SignCapabilitySerializer.EventHandler());
        CapabilityManager.INSTANCE.register(SignCapability.class, (Capability.IStorage)new SignCapabilitySerializer.Storage(), (Callable)new SignCapabilitySerializer.Callable());
        CapabilityManager.INSTANCE.register(Paintable.class, (Capability.IStorage)new PaintableSerializer.Storage(), (Callable)new PaintableSerializer.Callable());
        SignCapabilitySerializer.addListener(ExampleListener.class);
        NBTTagCompoundPacketHandler.addListener(Side.SERVER, new ServerReceiver());
        if (event.getSide().isClient()) {
            NBTTagCompoundPacketHandler.addListener(Side.CLIENT, new ClientReceiver());
        }
        Print.log("Loading complete.");
    }

    public static FCL getInstance() {
        return instance;
    }

    public static Side getSide() {
        return side;
    }

    public File getConfigDirectory() {
        return configdir;
    }

    public static final String getVersion() {
        return version;
    }

    public static final String getMinecraftVersion() {
        return mcv;
    }
}

