/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.capabilities.paint;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.mc.capabilities.paint.Paintable;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.packet.PacketNBTTagCompound;
import net.fexcraft.lib.mc.utils.Print;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PaintableImplementation
implements Paintable {
    private Object container;
    private RGB color = RGB.WHITE.copy();

    @Override
    public NBTBase writeToNBT(Capability<Paintable> capability, EnumFacing side) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("color", this.color.packed);
        if (this.color.alpha != 1.0f) {
            compound.func_74776_a("alpha", this.color.alpha);
        }
        return compound;
    }

    @Override
    public void readNBT(Capability<Paintable> capability, EnumFacing side, NBTBase nbt) {
        TileEntity tile;
        if (nbt == null || !(nbt instanceof NBTTagCompound)) {
            return;
        }
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.color.packed = compound.func_74762_e("color");
        if (compound.func_74764_b("alpha")) {
            this.color.alpha = compound.func_74760_g("alpha");
        }
        if (this.container instanceof TileEntity && (tile = (TileEntity)this.getHolder()).func_145831_w() != null) {
            tile.func_145831_w().func_175704_b(tile.func_174877_v(), tile.func_174877_v());
        }
    }

    @Override
    public RGB getColor() {
        return this.color;
    }

    @Override
    public RGB setColor(RGB newcolor) {
        RGB old = this.color;
        this.color = newcolor;
        return old;
    }

    @Override
    public void setColor(EnumDyeColor dye) {
        this.color = RGB.fromDyeColor(dye);
    }

    @Override
    public void updateClient() {
        if (this.container == null) {
            return;
        }
        NBTTagCompound compound = (NBTTagCompound)this.writeToNBT(null, null);
        compound.func_74778_a("target_listener", "fcl_gui");
        compound.func_74778_a("task", "paintable");
        NetworkRegistry.TargetPoint point = null;
        if (this.container instanceof Entity) {
            Entity entity = (Entity)this.container;
            compound.func_74778_a("type", "entity");
            compound.func_74768_a("id", entity.func_145782_y());
            point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 512.0);
        } else if (this.container instanceof TileEntity) {
            TileEntity tileentity = (TileEntity)this.container;
            compound.func_74778_a("type", "tileentity");
            compound.func_74772_a("pos", tileentity.func_174877_v().func_177986_g());
            point = new NetworkRegistry.TargetPoint(tileentity.func_145831_w().field_73011_w.getDimension(), (double)tileentity.func_174877_v().func_177958_n(), (double)tileentity.func_174877_v().func_177956_o(), (double)tileentity.func_174877_v().func_177952_p(), 512.0);
        } else {
            Print.log("UNKNOWN PAINTABLE CAPABILITY CONTAINER TYPE, THIS MAY CAUSE ERRORS;");
        }
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketNBTTagCompound(compound), point);
    }

    protected void setObject(Object object) {
        this.container = object;
    }

    @Override
    public Object getObject() {
        return this.container;
    }

    @Override
    public <H> H getHolder() {
        return (H)this.container;
    }
}

