/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.capabilities.sign;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.mc.capabilities.sign.SignCapability;
import net.fexcraft.lib.mc.network.Network;
import net.fexcraft.lib.mc.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ExampleListener
implements SignCapability.Listener {
    private static final ResourceLocation regname = new ResourceLocation("fcl:update_checker");
    private boolean active;
    private long lastcheck;

    @Override
    public ResourceLocation getId() {
        return regname;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean onPlayerInteract(SignCapability cap, PlayerInteractEvent event, IBlockState state, TileEntitySign tileentity) {
        if (event.getWorld().field_72995_K || !event.getEntityPlayer().func_184586_b(event.getEntityPlayer().func_184600_cs()).func_190926_b()) {
            return false;
        }
        if (!this.active) {
            if (tileentity.field_145915_a[0].func_150260_c().equals("[fcl-uc]") && tileentity.field_145915_a[1] != null && !tileentity.field_145915_a[1].func_150260_c().equals("")) {
                tileentity.field_145915_a[0] = new TextComponentString(Formatter.format("&0[&9FCL-UC&0]"));
                tileentity.field_145915_a[1] = new TextComponentString(tileentity.field_145915_a[1].func_150260_c().toLowerCase());
                this.lastcheck = Time.getDate();
                tileentity.field_145915_a[3] = new TextComponentString(Time.getAsString(Time.getDate()));
                String ver = this.getLatestVersion(tileentity.field_145915_a[1].func_150260_c());
                if (ver == null || ver.equals("null")) {
                    ver = "&6not found";
                }
                tileentity.field_145915_a[2] = new TextComponentString(Formatter.format(ver));
                this.active = true;
                cap.setActive();
                this.sendUpdate(tileentity);
                return true;
            }
        } else {
            if (this.lastcheck + 3600000L + 3600000L < Time.getDate()) {
                String ver = this.getLatestVersion(tileentity.field_145915_a[1].func_150260_c());
                if (ver == null || ver.equals("null")) {
                    ver = "&6not found";
                }
                tileentity.field_145915_a[2] = new TextComponentString(Formatter.format(ver).toLowerCase());
                this.lastcheck = Time.getDate();
                this.sendUpdate(tileentity);
                return true;
            }
            Print.bar(event.getEntityPlayer(), "Last check was less than 2 hours ago.");
        }
        return false;
    }

    private String getLatestVersion(String modid) {
        JsonObject obj = Network.getModData(modid);
        if (obj == null || obj.toString().equals("{}")) {
            return null;
        }
        if (obj.has("versions")) {
            for (JsonElement elm : obj.get("versions").getAsJsonArray()) {
                if (!elm.getAsJsonObject().get("version").getAsString().equals("1.12.2")) continue;
                return "&2" + elm.getAsJsonObject().get("latest_version").getAsString();
            }
            return "&cno version data";
        }
        if (obj.has("latest_version")) {
            return "&2" + obj.get("latest_version").getAsString();
        }
        return "&cno version data";
    }

    @Override
    public NBTBase writeToNBT(Capability<SignCapability> capability, EnumFacing side) {
        if (this.active) {
            return new NBTTagLong(this.lastcheck);
        }
        return null;
    }

    @Override
    public void readNBT(Capability<SignCapability> capability, EnumFacing side, NBTBase nbt) {
        if (nbt != null) {
            this.active = true;
            this.lastcheck = ((NBTTagLong)nbt).func_150291_c();
        } else {
            this.active = false;
        }
    }
}

