/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.capabilities.sign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fexcraft.lib.mc.capabilities.sign.SignCapability;
import net.fexcraft.lib.mc.capabilities.sign.SignCapabilitySerializer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class SignCapabilityImpl
implements SignCapability {
    private TileEntitySign tileentity;
    private boolean active;
    private List<SignCapability.Listener> listeners = new ArrayList<SignCapability.Listener>();

    public SignCapabilityImpl() {
        SignCapabilitySerializer.getListeners().forEach(clazz -> {
            try {
                this.listeners.add((SignCapability.Listener)clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void setTileEntity(TileEntitySign tileentity) {
        this.tileentity = tileentity;
    }

    @Override
    public TileEntitySign getTileEntity() {
        return this.tileentity;
    }

    @Override
    public NBTBase writeToNBT(Capability<SignCapability> capability, EnumFacing side) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("active", this.active);
        if (this.isActive()) {
            this.listeners.forEach(listener -> {
                NBTBase nbt = listener.writeToNBT(capability, side);
                if (nbt != null) {
                    compound.func_74782_a(listener.getId().toString(), nbt);
                }
            });
        }
        return compound;
    }

    @Override
    public void readNBT(Capability<SignCapability> capability, EnumFacing side, NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.active = compound.func_74767_n("active");
        if (this.isActive()) {
            this.listeners.forEach(listener -> listener.readNBT(capability, side, compound.func_74764_b(listener.getId().toString()) ? compound.func_74781_a(listener.getId().toString()) : null));
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean setActive() {
        this.active = true;
        return true;
    }

    @Override
    public Collection<SignCapability.Listener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean onPlayerInteract(PlayerInteractEvent event, IBlockState state, TileEntitySign tileentity) {
        for (SignCapability.Listener listener : this.listeners) {
            if (!listener.onPlayerInteract(this, event, state, tileentity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isListenerActive(ResourceLocation rs) {
        return this.listeners.stream().anyMatch(listener -> listener.getId().equals((Object)rs) && listener.isActive());
    }

    @Override
    public <T> T getListener(Class<T> clazz, ResourceLocation rs) {
        return (T)this.listeners.stream().filter(listener -> listener.getId().equals((Object)rs)).findFirst().get();
    }
}

