/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.gui;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.packet.PacketNBTTagCompound;
import net.fexcraft.lib.mc.utils.Print;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public abstract class GenericGui<CONTAINER extends GenericContainer>
extends GuiContainer {
    protected ResourceLocation texloc = null;
    protected TreeMap<String, BasicButton> buttons = new TreeMap();
    protected TreeMap<String, BasicText> texts = new TreeMap();
    protected TreeMap<String, TextField> fields = new TreeMap();
    protected CONTAINER container;
    protected boolean deftexrect = true;
    protected boolean defbackground = true;
    protected EntityPlayer player;

    public GenericGui(ResourceLocation texture, GenericContainer container, EntityPlayer player) {
        super((Container)(container == null ? new GenericContainer.DefImpl(player) : container));
        this.texloc = texture == null ? new ResourceLocation("minecraft:textures/blocks/stone.png") : texture;
        this.container = (GenericContainer)this.field_147002_h;
        this.player = player;
        ((GenericContainer)((Object)this.container)).setPlayer(this.player);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttons.clear();
        this.texts.clear();
        this.fields.clear();
        this.init();
    }

    protected void func_146976_a(float pticks, int mouseX, int mouseY) {
        if (this.defbackground) {
            super.func_146276_q_();
        }
        this.predraw(pticks, mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(this.texloc);
        if (this.deftexrect) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.drawbackground(pticks, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.buttons.forEach((key, button) -> {
            button.hovered(mouseX, mouseY);
            button.draw(this, pticks, mouseX, mouseY);
        });
        this.texts.forEach((key, text) -> {
            if (text.visible) {
                text.hovered(mouseX, mouseY);
                this.field_146297_k.field_71466_p.func_78276_b(text.string, text.x, text.y, text.hovered ? text.hovercolor : text.color);
            }
        });
        this.fields.forEach((key, elm) -> elm.func_146194_f());
    }

    public static void openGui(int gui, int[] xyz, String listener) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("target_listener", listener == null ? "fcl_gui" : listener);
        compound.func_74778_a("task", "open_gui");
        compound.func_74768_a("gui", gui);
        if (xyz != null) {
            compound.func_74783_a("args", xyz);
        }
        PacketHandler.getInstance().sendToServer((IMessage)new PacketNBTTagCompound(compound));
    }

    public static void openGui(int gui, int[] xyz, String listener, NBTTagCompound data) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("target_listener", listener == null ? "fcl_gui" : listener);
        compound.func_74778_a("task", "open_gui");
        compound.func_74768_a("gui", gui);
        compound.func_74782_a("data", (NBTBase)data);
        if (xyz != null) {
            compound.func_74783_a("args", xyz);
        }
        PacketHandler.getInstance().sendToServer((IMessage)new PacketNBTTagCompound(compound));
    }

    protected abstract void init();

    protected abstract void predraw(float var1, int var2, int var3);

    protected abstract void drawbackground(float var1, int var2, int var3);

    protected abstract boolean buttonClicked(int var1, int var2, int var3, String var4, BasicButton var5);

    protected abstract void scrollwheel(int var1, int var2, int var3);

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (Map.Entry<String, BasicButton> entry : this.buttons.entrySet()) {
                if (!entry.getValue().mousePressed(this.field_146297_k, mouseX, mouseY)) continue;
                Print.debug("[GG] Button Pressed: " + entry.getKey());
                this.buttonClicked(mouseX, mouseY, mouseButton, entry.getKey(), entry.getValue());
                return;
            }
        }
        if (!this.fields.isEmpty()) {
            for (TextField field : this.fields.values()) {
                if (!field.func_146192_a(mouseX, mouseY, mouseButton)) continue;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.fields.isEmpty()) {
            boolean bool = false;
            for (Map.Entry<String, TextField> entry : this.fields.entrySet()) {
                if (bool) break;
                if (!entry.getValue().func_146201_a(typedChar, keyCode)) continue;
                bool = true;
            }
            if (bool && !this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                super.func_73869_a(typedChar, keyCode);
            }
        }
        if (keyCode == 1) {
            this.player.func_71053_j();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int e = Mouse.getEventDWheel();
        if (e == 0) {
            return;
        }
        int am = e > 0 ? -1 : 1;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        boolean exit = false;
        for (BasicButton basicButton : this.buttons.values()) {
            if (exit) break;
            if (!basicButton.hovered(x, y)) continue;
            exit = basicButton.scrollwheel(am, x, y);
        }
        for (BasicText basicText : this.texts.values()) {
            if (exit) break;
            if (!basicText.hovered(x, y)) continue;
            exit = basicText.scrollwheel(am, x, y);
        }
        if (!exit) {
            this.scrollwheel(am, x, y);
        }
    }

    public ResourceLocation getTexLoc() {
        return this.texloc;
    }

    public static class NumberField
    extends TextField {
        private String regex = "[^\\d\\-\\.\\,]";

        public NumberField(int id, FontRenderer renderer, int x, int y, int width, int height) {
            super(id, renderer, x, y, width, height, true);
        }

        public NumberField(int id, FontRenderer renderer, int x, int y, int width, int height, boolean draw) {
            super(id, renderer, x, y, width, height, draw);
        }

        public NumberField setRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public void func_146191_b(String text) {
            super.func_146191_b(text.replaceAll(this.regex, ""));
        }
    }

    public static class TextField
    extends GuiTextField {
        public TextField(int id, FontRenderer renderer, int x, int y, int width, int height) {
            this(id, renderer, x, y, width, height, true);
        }

        public TextField(int id, FontRenderer renderer, int x, int y, int width, int height, boolean draw) {
            super(id, renderer, x, y, width, height);
            this.func_146185_a(draw);
        }

        public Integer getIntegerValue() {
            try {
                return Integer.parseInt(this.func_146179_b());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Float getValue() {
            try {
                return Float.valueOf(Float.parseFloat(this.func_146179_b()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public TextField setMaxLength(int length) {
            super.func_146203_f(length);
            return this;
        }
    }

    public static class BasicText {
        private static final RGB defcolor = new RGB(128, 128, 128);
        public int x;
        public int y;
        public int width;
        public int color;
        public int hovercolor;
        public String string;
        public boolean visible;
        public boolean hovered;
        public boolean hoverable;

        public BasicText(int x, int y, int width, @Nullable Integer color, String string) {
            this.hovercolor = new RGB((int)244, (int)215, (int)66, (float)0.5f).packed;
            this.visible = true;
            this.x = x;
            this.y = y;
            this.width = width;
            this.string = string;
            this.color = color == null ? BasicText.defcolor.packed : color;
        }

        public BasicText(int x, int y, int width, @Nullable Integer color, String string, boolean hover, @Nullable Integer hovercolor) {
            this(x, y, width, color, string);
            this.hoverable = hover;
            if (hovercolor != null) {
                this.hovercolor = hovercolor;
            }
        }

        public boolean hovered(int mouseX, int mouseY) {
            return this.hoverable ? (this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + 8) : false;
        }

        public boolean scrollwheel(int am, int x, int y) {
            return false;
        }

        public void translate() {
            this.string = I18n.func_135052_a((String)this.string, (Object[])new Object[0]);
        }

        public void translate(Object ... objects) {
            this.string = I18n.func_135052_a((String)this.string, (Object[])objects);
        }
    }

    public static class BasicButton {
        public int x;
        public int y;
        public int tx;
        public int ty;
        public int sizex;
        public int sizey;
        public boolean enabled;
        public boolean visible = true;
        public boolean hovered;
        public String name;
        private RGB rgb;
        public RGB rgb_disabled = new RGB(119, 119, 119, 0.5f);
        public RGB rgb_none = new RGB(255, 255, 255, 0.5f);
        public RGB rgb_hover = new RGB(244, 215, 66, 0.5f);

        public BasicButton(String name, int x, int y, int tx, int ty, int sizex, int sizey, boolean enabled) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.sizex = sizex;
            this.sizey = sizey;
            this.enabled = enabled;
            this.tx = tx;
            this.ty = ty;
        }

        public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
            return this.enabled && this.visible && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.sizex && mouseY < this.y + this.sizey;
        }

        public boolean hovered(int mouseX, int mouseY) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.sizex && mouseY < this.y + this.sizey;
            return this.hovered;
        }

        public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            this.rgb = this.hovered ? (this.enabled ? this.rgb_hover : this.rgb_disabled) : this.rgb_none;
            RGB.glColorReset();
            this.rgb.glColorApply();
            gui.func_73729_b(this.x, this.y, this.tx, this.ty, this.sizex, this.sizey);
            RGB.glColorReset();
        }

        public boolean scrollwheel(int am, int x, int y) {
            return false;
        }
    }
}

