/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.render;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.fexcraft.lib.mc.render.FCLItemModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class FCLItemModelLoader
implements ICustomModelLoader {
    private static final FCLItemModelLoader INSTANCE = new FCLItemModelLoader();
    private static final TreeMap<ResourceLocation, FCLItemModel> MAP = new TreeMap();

    public void func_110549_a(IResourceManager resmag) {
        MAP.forEach((key, value) -> value.onResourceManagerReload(resmag));
    }

    @Nullable
    public static final Object addItemModel(ResourceLocation loc, FCLItemModel model) {
        if (!loc.toString().contains(":models/item/") && !loc.toString().contains(":models/block/")) {
            ResourceLocation rs = new ResourceLocation(loc.func_110624_b(), "models/item/" + loc.func_110623_a());
            return MAP.put(rs, model);
        }
        return MAP.put(loc, model);
    }

    @Nullable
    public FCLItemModel getItemModel(ResourceLocation modelloc) {
        return MAP.get(modelloc);
    }

    public boolean accepts(ResourceLocation modelloc) {
        return MAP.containsKey(modelloc);
    }

    public IModel loadModel(ResourceLocation modelloc) throws Exception {
        return new Model(modelloc);
    }

    public static FCLItemModelLoader getInstance() {
        return INSTANCE;
    }

    private static class OverrideList
    extends ItemOverrideList {
        private static final OverrideList INSTANCE = new OverrideList();

        private OverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel org_model, ItemStack stack, World world, EntityLivingBase entity) {
            ((BakedModel)org_model).getModelState().setData(stack, entity, world);
            return org_model;
        }
    }

    private static class ModelState
    implements IModelState {
        private ItemStack stack;
        private EntityLivingBase entity;

        private ModelState() {
        }

        public void setData(ItemStack stack, EntityLivingBase entity, World world) {
            this.stack = stack;
            this.entity = entity;
        }

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            return Optional.empty();
        }
    }

    private static class BakedModel
    implements IBakedModel {
        private final ModelState state;
        private final ResourceLocation modelloc;

        private BakedModel(ResourceLocation modelLocation, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ModelState state) {
            this.modelloc = modelLocation;
            this.state = state;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return Collections.emptyList();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType perspective) {
            FCLItemModel model = INSTANCE.getItemModel(this.modelloc);
            if (model != null) {
                model.renderItem(perspective, this.state.stack, this.state.entity);
            }
            return Pair.of((Object)this, null);
        }

        public boolean func_188618_c() {
            return true;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return ModelLoader.White.INSTANCE;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return OverrideList.INSTANCE;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_177555_b() {
            return false;
        }

        public ModelState getModelState() {
            return this.state;
        }
    }

    private static class Model
    implements IModel {
        private final ResourceLocation modelloc;

        private Model(ResourceLocation rs) {
            this.modelloc = rs;
        }

        public Collection<ResourceLocation> getDependencies() {
            return Collections.emptyList();
        }

        public IModelState getDefaultState() {
            return new ModelState();
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> func) {
            return new BakedModel(this.modelloc, func, new ModelState());
        }

        public Collection<ResourceLocation> getTextures() {
            return Collections.singleton(this.modelloc);
        }
    }
}

