/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fexcraft.lib.common.math.Vec3f;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class Pos {
    public static final Pos NULL = new Pos(0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float z;

    public Pos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Pos(float[] pos) {
        this.x = pos.length >= 1 ? pos[0] : 0.0f;
        this.y = pos.length >= 2 ? pos[0] : 0.0f;
        this.z = pos.length >= 3 ? pos[0] : 0.0f;
    }

    public Pos copy() {
        return new Pos(this.x, this.y, this.z);
    }

    public Pos clone() {
        return this.copy();
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public float to16FloatX() {
        return 0.0625f * this.x;
    }

    public float to16FloatY() {
        return 0.0625f * this.y;
    }

    public float to16FloatZ() {
        return 0.0625f * this.z;
    }

    public JsonElement toJson(boolean asarray) {
        if (asarray) {
            JsonArray array = new JsonArray();
            array.add((Number)Float.valueOf(this.x));
            array.add((Number)Float.valueOf(this.y));
            array.add((Number)Float.valueOf(this.z));
            return array;
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)Float.valueOf(this.x));
        obj.addProperty("y", (Number)Float.valueOf(this.y));
        obj.addProperty("z", (Number)Float.valueOf(this.z));
        return obj;
    }

    public static Pos fromJson(JsonElement elm, boolean wasarray) {
        float z;
        float y;
        float x;
        if (wasarray) {
            JsonArray array = elm.getAsJsonArray();
            x = array.size() > 0 ? array.get(0).getAsFloat() : 0.0f;
            y = array.size() > 1 ? array.get(1).getAsFloat() : 0.0f;
            z = array.size() > 2 ? array.get(2).getAsFloat() : 0.0f;
        } else {
            JsonObject obj = elm.getAsJsonObject();
            x = obj.has("x") ? obj.get("x").getAsFloat() : 0.0f;
            y = obj.has("y") ? obj.get("y").getAsFloat() : 0.0f;
            z = obj.has("z") ? obj.get("z").getAsFloat() : 0.0f;
        }
        return new Pos(x, y, z);
    }

    private static String prefix(String prefix) {
        return prefix == null ? "" : prefix + "_";
    }

    public static Pos fromNBT(String prefix, NBTTagCompound compound) {
        prefix = Pos.prefix(prefix);
        return new Pos(compound.func_74760_g(prefix + "x"), compound.func_74760_g(prefix + "y"), compound.func_74760_g(prefix + "z"));
    }

    public NBTTagCompound toNBT(String prefix, NBTTagCompound compound) {
        prefix = Pos.prefix(prefix);
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74776_a(prefix + "x", this.x);
        compound.func_74776_a(prefix + "y", this.y);
        compound.func_74776_a(prefix + "z", this.z);
        return compound;
    }

    public void translate() {
        GL11.glTranslatef((float)(this.x == 0.0f ? 0.0f : this.to16FloatX()), (float)(this.y == 0.0f ? 0.0f : this.to16FloatY()), (float)(this.z == 0.0f ? 0.0f : this.to16FloatZ()));
    }

    public void translateR() {
        GL11.glTranslatef((float)(this.x == 0.0f ? 0.0f : -this.to16FloatX()), (float)(this.y == 0.0f ? 0.0f : -this.to16FloatY()), (float)(this.z == 0.0f ? 0.0f : -this.to16FloatZ()));
    }

    public Vec3d to16Double() {
        return new Vec3d((double)this.to16FloatX(), (double)this.to16FloatY(), (double)this.to16FloatZ());
    }

    public Vec3f to16Float() {
        return new Vec3f(this.to16FloatX(), this.to16FloatY(), this.to16FloatZ());
    }

    public Pos add(Pos pos) {
        return new Pos(this.x + pos.x, this.y + pos.y, this.z + pos.z);
    }

    public Pos sub(Pos pos) {
        return new Pos(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }
}

