/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.tmt.ModelRendererTurbo;

public class BoxBuilder {
    private final ModelRendererTurbo root;
    private float x;
    private float y;
    private float z;
    private float expansion;
    private float w;
    private float h;
    private float d;
    private boolean[] invisible = new boolean[6];
    private float[][] uv = new float[6][];
    private boolean[] detached = new boolean[6];
    private Vec3f[] corners = new Vec3f[8];
    private static final Vec3f NULLVEC = new Vec3f(0.0f, 0.0f, 0.0f);

    public BoxBuilder() {
        this(null);
    }

    public BoxBuilder(ModelRendererTurbo root) {
        this.root = root == null ? new ModelRendererTurbo(null) : root;
    }

    public BoxBuilder setOffset(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public BoxBuilder setSize(float w, float h, float d) {
        this.w = w;
        this.h = h;
        this.d = d;
        return this;
    }

    public BoxBuilder setExpansion(float exp) {
        this.expansion = exp;
        return this;
    }

    public BoxBuilder removePolygon(int index) {
        if (index < 0 || index > 5) {
            return this;
        }
        this.invisible[index] = true;
        return this;
    }

    public BoxBuilder removePolygons(int ... poly_indices) {
        for (int index : poly_indices) {
            if (index < 0 || index > 5) continue;
            this.invisible[index] = true;
        }
        return this;
    }

    public BoxBuilder removePolygons(boolean ... sides) {
        for (int index = 0; index < 6; ++index) {
            if (sides.length < index + 1 || !sides[index]) continue;
            this.invisible[index] = true;
        }
        return this;
    }

    public BoxBuilder setPolygonUV(int poly_index, float[] uv) {
        if (poly_index < 0 || poly_index > 5) {
            return this;
        }
        this.uv[poly_index] = uv;
        return this;
    }

    public BoxBuilder setPolygonUVs(int[] poly_indices, float[][] uvs) {
        for (int i = 0; i < poly_indices.length; ++i) {
            if (poly_indices[i] < 0 || poly_indices[i] > 5) continue;
            this.setPolygonUV(poly_indices[i], uvs[i]);
        }
        return this;
    }

    public BoxBuilder setPolygonUVs(float[][] uvs) {
        for (int index = 0; index < 6 && index < uvs.length; ++index) {
            this.setPolygonUV(index, uvs[index]);
        }
        return this;
    }

    public BoxBuilder setDetachedUV(int ... indices) {
        for (int index : indices) {
            if (index < 0 || index > 5) continue;
            this.detached[index] = true;
        }
        return this;
    }

    public BoxBuilder setDetachedUV(boolean ... bools) {
        int index = 0;
        while (index < 6 && index < bools.length) {
            this.setDetachedUV(index++);
        }
        return this;
    }

    public BoxBuilder setCorner(int index, Vec3f corner) {
        if (index < 0 || index > 7) {
            return this;
        }
        this.corners[index] = corner;
        return this;
    }

    public BoxBuilder setCorner(int index, float x, float y, float z) {
        if (index < 0 || index > 7) {
            return this;
        }
        this.corners[index] = new Vec3f(x, y, z);
        return this;
    }

    public BoxBuilder setCorners(Vec3f cor0, Vec3f cor1, Vec3f cor2, Vec3f cor3, Vec3f cor4, Vec3f cor5, Vec3f cor6, Vec3f cor7) {
        this.corners[0] = cor0;
        this.corners[1] = cor1;
        this.corners[2] = cor2;
        this.corners[3] = cor3;
        this.corners[4] = cor4;
        this.corners[5] = cor5;
        this.corners[6] = cor6;
        this.corners[7] = cor7;
        return this;
    }

    public BoxBuilder setCorners(float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float x5, float y5, float z5, float x6, float y6, float z6, float x7, float y7, float z7) {
        this.corners[0] = new Vec3f(x0, y0, z0);
        this.corners[1] = new Vec3f(x1, y1, z1);
        this.corners[2] = new Vec3f(x2, y2, z2);
        this.corners[3] = new Vec3f(x3, y3, z3);
        this.corners[4] = new Vec3f(x4, y4, z4);
        this.corners[5] = new Vec3f(x5, y5, z5);
        this.corners[6] = new Vec3f(x6, y6, z6);
        this.corners[7] = new Vec3f(x7, y7, z7);
        return this;
    }

    public ModelRendererTurbo build() {
        float[] v7;
        float[] v6;
        float[] v5;
        float[] v4;
        float[] v3;
        float[] v2;
        float[] v1;
        float[] v0;
        boolean isshapebox = false;
        for (Vec3f corner : this.corners) {
            if (corner == null) continue;
            isshapebox = true;
            break;
        }
        boolean anyoff = false;
        for (boolean bool : this.invisible) {
            if (!bool) continue;
            anyoff = true;
            break;
        }
        if (isshapebox) {
            Vec3f c0 = this.corners[0] == null ? NULLVEC : this.corners[0];
            Vec3f c1 = this.corners[1] == null ? NULLVEC : this.corners[1];
            Vec3f c2 = this.corners[2] == null ? NULLVEC : this.corners[2];
            Vec3f c3 = this.corners[3] == null ? NULLVEC : this.corners[3];
            Vec3f c4 = this.corners[4] == null ? NULLVEC : this.corners[4];
            Vec3f c5 = this.corners[5] == null ? NULLVEC : this.corners[5];
            Vec3f c6 = this.corners[6] == null ? NULLVEC : this.corners[6];
            Vec3f c7 = this.corners[7] == null ? NULLVEC : this.corners[7];
            float xw = this.x + this.w;
            float yh = this.y + this.h;
            float zd = this.z + this.d;
            if (this.root.mirror) {
                float fl = xw;
                xw = this.x;
                this.x = fl;
            }
            v0 = new float[]{this.x - c0.xCoord, this.y - c0.yCoord, this.z - c0.zCoord};
            v1 = new float[]{xw + c1.xCoord, this.y - c1.yCoord, this.z - c1.zCoord};
            v2 = new float[]{xw + c5.xCoord, yh + c5.yCoord, this.z - c5.zCoord};
            v3 = new float[]{this.x - c4.xCoord, yh + c4.yCoord, this.z - c4.zCoord};
            v4 = new float[]{this.x - c3.xCoord, this.y - c3.yCoord, zd + c3.zCoord};
            v5 = new float[]{xw + c2.xCoord, this.y - c2.yCoord, zd + c2.zCoord};
            v6 = new float[]{xw + c6.xCoord, yh + c6.yCoord, zd + c6.zCoord};
            v7 = new float[]{this.x - c7.xCoord, yh + c7.yCoord, zd + c7.zCoord};
        } else {
            if (this.w == 0.0f) {
                this.w = 0.01f;
            }
            if (this.h == 0.0f) {
                this.h = 0.01f;
            }
            if (this.d == 0.0f) {
                this.d = 0.01f;
            }
            float x1 = this.x + this.w;
            float y1 = this.y + this.h;
            float z1 = this.z + this.d;
            x1 += this.expansion;
            y1 += this.expansion;
            z1 += this.expansion;
            if (this.root.mirror) {
                float xTemp = x1;
                x1 = this.x;
                this.x = xTemp;
            }
            v0 = new float[]{this.x, this.y, this.z};
            v1 = new float[]{x1, this.y, this.z};
            v2 = new float[]{x1, y1, this.z};
            v3 = new float[]{this.x, y1, this.z};
            v4 = new float[]{this.x, this.y, z1};
            v5 = new float[]{x1, this.y, z1};
            v6 = new float[]{x1, y1, z1};
            v7 = new float[]{this.x, y1, z1};
        }
        TexturedVertex[] verts = new TexturedVertex[8];
        TexturedPolygon[] poly = new TexturedPolygon[6];
        TexturedVertex tv0 = new TexturedVertex(v0[0], v0[1], v0[2], 0.0f, 0.0f);
        TexturedVertex tv1 = new TexturedVertex(v1[0], v1[1], v1[2], 0.0f, 8.0f);
        TexturedVertex tv2 = new TexturedVertex(v2[0], v2[1], v2[2], 8.0f, 8.0f);
        TexturedVertex tv3 = new TexturedVertex(v3[0], v3[1], v3[2], 8.0f, 0.0f);
        TexturedVertex tv4 = new TexturedVertex(v4[0], v4[1], v4[2], 0.0f, 0.0f);
        TexturedVertex tv5 = new TexturedVertex(v5[0], v5[1], v5[2], 0.0f, 8.0f);
        TexturedVertex tv6 = new TexturedVertex(v6[0], v6[1], v6[2], 8.0f, 8.0f);
        TexturedVertex tv7 = new TexturedVertex(v7[0], v7[1], v7[2], 8.0f, 0.0f);
        verts[0] = tv0;
        verts[1] = tv1;
        verts[2] = tv2;
        verts[3] = tv3;
        verts[4] = tv4;
        verts[5] = tv5;
        verts[6] = tv6;
        verts[7] = tv7;
        float tx = this.root.texoffx;
        float ty = this.root.texoffy;
        float w = this.w;
        float h = this.h;
        float d = this.d;
        if (w % 1.0f != 0.0f) {
            float f = w < 1.0f ? 1.0f : (w = (float)((int)w + (w % 1.0f > 0.5f ? 1 : 0)));
        }
        if (h % 1.0f != 0.0f) {
            float f = h < 1.0f ? 1.0f : (h = (float)((int)h + (h % 1.0f > 0.5f ? 1 : 0)));
        }
        if (d % 1.0f != 0.0f) {
            float f = d < 1.0f ? 1.0f : (d = (float)((int)d + (d % 1.0f > 0.5f ? 1 : 0)));
        }
        if (!anyoff) {
            poly[0] = this.genPolygonWithUV(0, new TexturedVertex[]{tv5, tv1, tv2, tv6}, tx, ty, d + w, d, d, h);
            poly[1] = this.genPolygonWithUV(1, new TexturedVertex[]{tv0, tv4, tv7, tv3}, tx, ty, 0.0f, d, d, h);
            poly[2] = this.genPolygonWithUV(2, new TexturedVertex[]{tv5, tv4, tv0, tv1}, tx, ty, d, 0.0f, w, d);
            poly[3] = this.genPolygonWithUV(3, new TexturedVertex[]{tv2, tv3, tv7, tv6}, tx, ty, d + w, 0.0f, w, d);
            poly[4] = this.genPolygonWithUV(4, new TexturedVertex[]{tv1, tv0, tv3, tv2}, tx, ty, d, d, w, h);
            poly[5] = this.genPolygonWithUV(5, new TexturedVertex[]{tv4, tv5, tv6, tv7}, tx, ty, d + w + d, d, w, h);
        } else {
            float x3;
            float yp = this.detached(2) && this.detached(3) ? 0.0f : d;
            float x0 = this.detached(1) ? 0.0f : d;
            float x1 = this.detached(2) ? 0.0f : w;
            float x2 = this.detached(4) ? 0.0f : w;
            float f = x3 = this.detached(0) ? 0.0f : d;
            if (!this.invisible[0]) {
                poly[0] = this.genPolygonWithUV(0, new TexturedVertex[]{tv5, tv1, tv2, tv6}, tx, ty, x0 + x2, yp, d, h);
            }
            if (!this.invisible[1]) {
                poly[1] = this.genPolygonWithUV(1, new TexturedVertex[]{tv0, tv4, tv7, tv3}, tx, ty, 0.0f, yp, d, h);
            }
            if (!this.invisible[2]) {
                poly[2] = this.genPolygonWithUV(2, new TexturedVertex[]{tv5, tv4, tv0, tv1}, tx, ty, x0, 0.0f, w, d);
            }
            if (!this.invisible[3]) {
                poly[3] = this.genPolygonWithUV(3, new TexturedVertex[]{tv2, tv3, tv7, tv6}, tx, ty, x0 + x1, 0.0f, w, d);
            }
            if (!this.invisible[4]) {
                poly[4] = this.genPolygonWithUV(4, new TexturedVertex[]{tv1, tv0, tv3, tv2}, tx, ty, x0, yp, w, h);
            }
            if (!this.invisible[5]) {
                poly[5] = this.genPolygonWithUV(5, new TexturedVertex[]{tv4, tv5, tv6, tv7}, tx, ty, x0 + x2 + x3, yp, w, h);
            }
        }
        if (this.root.mirror ^ this.root.flip) {
            for (int l = 0; l < poly.length; ++l) {
                if (poly[l] == null) continue;
                poly[l].flipFace();
            }
        }
        if (anyoff) {
            int polis = 0;
            int processed = 0;
            for (int i = 0; i < poly.length; ++i) {
                if (poly[i] == null) continue;
                ++polis;
            }
            TexturedPolygon[] polygons = new TexturedPolygon[polis];
            for (int i = 0; i < poly.length; ++i) {
                if (poly[i] == null) continue;
                polygons[processed] = poly[i];
                ++processed;
            }
            poly = polygons;
        }
        return this.root.copyTo(verts, poly);
    }

    private boolean detached(int i) {
        return this.invisible[i] || this.detached[i];
    }

    private TexturedPolygon genPolygonWithUV(int index, TexturedVertex[] vertices, float tx, float ty, float x, float y, float ex, float ey) {
        float[] cuv;
        float[] fArray = cuv = index < 0 || this.uv[index] == null ? null : this.uv[index];
        if (index > -1 && this.detached[index]) {
            tx = 0.0f;
            ty = 0.0f;
        }
        if (cuv == null) {
            float xs = tx + x;
            float xe = tx + x + ex;
            float ys = ty + y;
            float ye = ty + y + ey;
            vertices[0] = vertices[0].setTexturePosition(xe / this.root.textureWidth, ys / this.root.textureHeight);
            vertices[1] = vertices[1].setTexturePosition(xs / this.root.textureWidth, ys / this.root.textureHeight);
            vertices[2] = vertices[2].setTexturePosition(xs / this.root.textureWidth, ye / this.root.textureHeight);
            vertices[3] = vertices[3].setTexturePosition(xe / this.root.textureWidth, ye / this.root.textureHeight);
        } else if (cuv.length == 2) {
            float xs = tx + cuv[0];
            float xe = tx + cuv[0] + ex;
            float ys = ty + cuv[1];
            float ye = ty + cuv[1] + ey;
            vertices[0] = vertices[0].setTexturePosition(xe / this.root.textureWidth, ys / this.root.textureHeight);
            vertices[1] = vertices[1].setTexturePosition(xs / this.root.textureWidth, ys / this.root.textureHeight);
            vertices[2] = vertices[2].setTexturePosition(xs / this.root.textureWidth, ye / this.root.textureHeight);
            vertices[3] = vertices[3].setTexturePosition(xe / this.root.textureWidth, ye / this.root.textureHeight);
        } else if (cuv.length == 4) {
            float xs = tx + cuv[0];
            float xe = tx + cuv[2];
            float ys = ty + cuv[1];
            float ye = ty + cuv[3];
            vertices[0] = vertices[0].setTexturePosition(xe / this.root.textureWidth, ys / this.root.textureHeight);
            vertices[1] = vertices[1].setTexturePosition(xs / this.root.textureWidth, ys / this.root.textureHeight);
            vertices[2] = vertices[2].setTexturePosition(xs / this.root.textureWidth, ye / this.root.textureHeight);
            vertices[3] = vertices[3].setTexturePosition(xe / this.root.textureWidth, ye / this.root.textureHeight);
        } else if (cuv.length == 8) {
            vertices[0] = vertices[0].setTexturePosition((tx + cuv[0]) / this.root.textureWidth, (ty + cuv[1]) / this.root.textureHeight);
            vertices[1] = vertices[1].setTexturePosition((tx + cuv[2]) / this.root.textureWidth, (ty + cuv[3]) / this.root.textureHeight);
            vertices[2] = vertices[2].setTexturePosition((tx + cuv[4]) / this.root.textureWidth, (ty + cuv[5]) / this.root.textureHeight);
            vertices[3] = vertices[3].setTexturePosition((tx + cuv[6]) / this.root.textureWidth, (ty + cuv[7]) / this.root.textureHeight);
        } else {
            return this.genPolygonWithUV(-1, vertices, tx, ty, x, y, ex, ey);
        }
        return new TexturedPolygon(vertices);
    }
}

