/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fexcraft.lib.common.json.JsonToTMT;
import net.fexcraft.lib.common.json.JsonUtil;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.lib.tmt.ModelBase;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.lib.tmt.PolygonList;
import net.minecraft.util.ResourceLocation;

public class Format2Model {
    private ArrayList<PolygonList> groups = new ArrayList();
    private ArrayList<String> creators = new ArrayList();
    public int textureX = 256;
    public int textureY = 256;

    public Format2Model() {
    }

    public Format2Model(JsonObject obj) {
        this();
        if (obj == null) {
            Static.exception(new Exception("MODEL JSON OBJ IS NULL, LOADING ABORTED"), false);
            return;
        }
        this.creators = JsonUtil.jsonArrayToStringArray(obj.get("creators").getAsJsonArray());
        this.textureX = obj.get("texture_size_x").getAsInt();
        this.textureY = obj.get("texture_size_y").getAsInt();
        try {
            if (JsonUtil.getIfExists(obj, "format", 2).intValue() == 1) {
                JsonObject modelobj = obj.get("model").getAsJsonObject();
                for (Map.Entry entry : modelobj.entrySet()) {
                    this.groups.add(new PolygonList((String)entry.getKey(), JsonToTMT.parse(null, ((JsonElement)entry.getValue()).getAsJsonArray(), this.textureX, this.textureY)));
                }
            } else {
                JsonObject modelobj = obj.get("groups").getAsJsonObject();
                for (Map.Entry entry : modelobj.entrySet()) {
                    this.groups.add(new PolygonList((String)entry.getKey(), JsonToTMT.parse(null, ((JsonElement)entry.getValue()).getAsJsonObject().get("polygons").getAsJsonArray(), this.textureX, this.textureY)));
                }
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            Static.stop();
        }
    }

    public void render() {
        for (PolygonList list : this.groups) {
            list.render();
        }
    }

    public PolygonList get(String name) {
        for (PolygonList group : this.groups) {
            if (!group.name.equals(name)) continue;
            return group;
        }
        return null;
    }

    public boolean addToCreators(String str) {
        return this.creators.add(str);
    }

    public List<String> getCreators() {
        return ImmutableList.copyOf(this.creators);
    }

    public void translate(float x, float y, float z) {
        this.groups.forEach(group -> group.translate(x, y, z));
    }

    public void rotate(float x, float y, float z, boolean apply) {
        this.groups.forEach(group -> group.rotate(x, y, z, apply));
    }

    public void fixRotations() {
        this.groups.forEach(group -> Format2Model.fixRotations(group));
    }

    public void bindTexture(ResourceLocation texture) {
        ModelBase.bindTexture(texture);
    }

    public static void fixRotations(PolygonList group) {
        for (ModelRendererTurbo model : group) {
            if (model.isShape3D) {
                model.rotationAngleY = -model.rotationAngleY;
                model.rotationAngleX = -model.rotationAngleX;
                model.rotationAngleZ = -model.rotationAngleZ + 180.0f;
                continue;
            }
            model.rotationAngleZ = -model.rotationAngleZ;
        }
    }

    public void add(String key, ModelRendererTurbo[] mrts) {
        this.groups.add(new PolygonList(key, mrts));
    }

    public PolygonList get(String string, boolean allownull) {
        PolygonList list = this.get(string);
        return list == null ? (allownull ? list : PolygonList.EMPTY) : list;
    }
}

