/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public abstract class ModelBase {
    public abstract void render();

    public void render(ModelRendererTurbo[] model) {
        for (ModelRendererTurbo sub : model) {
            sub.render();
        }
    }

    public void render(ModelRendererTurbo[] model, float scale, boolean rotorder) {
        for (ModelRendererTurbo sub : model) {
            sub.render(scale);
        }
    }

    protected void translate(ModelRendererTurbo[] model, float x, float y, float z) {
        for (ModelRendererTurbo mod : model) {
            mod.rotationPointX += x;
            mod.rotationPointY += y;
            mod.rotationPointZ += z;
        }
    }

    public abstract void translate(float var1, float var2, float var3);

    protected void rotate(ModelRendererTurbo[] model, float x, float y, float z) {
        for (ModelRendererTurbo mod : model) {
            mod.rotationAngleX += x;
            mod.rotationAngleY += y;
            mod.rotationAngleZ += z;
        }
    }

    public abstract void rotate(float var1, float var2, float var3);

    protected void flip(ModelRendererTurbo[] model) {
        ModelBase.fixRotations(model);
    }

    public void flipAll() {
    }

    public static void fixRotations(ModelRendererTurbo[] array) {
        for (ModelRendererTurbo model : array) {
            if (model.isShape3D) {
                model.rotationAngleY = -model.rotationAngleY;
                model.rotationAngleX = -model.rotationAngleX;
                model.rotationAngleZ = -model.rotationAngleZ + 180.0f;
                continue;
            }
            model.rotationAngleZ = -model.rotationAngleZ;
        }
    }

    public static final void bindTexture(ResourceLocation rs) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rs);
    }

    public static void addAll(ArrayList<ModelRendererTurbo> mrts, ModelRendererTurbo[] array) {
        for (ModelRendererTurbo model : array) {
            mrts.add(model);
        }
    }

    public static void applyColor(ModelRendererTurbo[] array, RGB color) {
        for (ModelRendererTurbo model : array) {
            model.setColor(color);
        }
    }
}

