/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

class ConfigHandler {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.IntValue BASICRANGE;
    public static ForgeConfigSpec.IntValue ADVANCEDRANGE;

    ConfigHandler() {
    }

    private static void initConfig() {
        COMMON_BUILDER.comment("General settings").push("similsaxtranstructors");
        COMMON_BUILDER.push("range").comment("How far away from you this tool can build");
        BASICRANGE = COMMON_BUILDER.comment("How far you can build using the basic transtructor").defineInRange("basic", 32, 2, 128);
        ADVANCEDRANGE = COMMON_BUILDER.comment("How far you can build using the advanced transtructor").defineInRange("advanced", 128, 2, 256);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        ConfigHandler.initConfig();
    }
}

