/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors;

import com.vorquel.similsaxtranstructors.ConfigHandler;
import com.vorquel.similsaxtranstructors.SimilsaxRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemSimilsax
extends Item {
    private static final int[] sidesXY = new int[]{4, 5, 0, 1};
    private static final int[] sidesYZ = new int[]{0, 1, 2, 3};
    private static final int[] sidesZX = new int[]{2, 3, 4, 5};
    public static final float LO = 0.25f;
    public static final float HI = 0.75f;

    public ItemSimilsax(Item.Properties properties) {
        super(properties.func_200916_a(ItemGroup.field_78040_i));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockState block = context.func_195991_k().func_180495_p(context.func_195995_a());
        ItemStack blockStack = new ItemStack((IItemProvider)block.func_177230_c());
        if (!player.func_184812_l_() && !player.field_71071_by.func_70431_c(blockStack)) {
            return ActionResultType.PASS;
        }
        Direction side = ItemSimilsax.getSide(context.func_196000_l(), context.func_221532_j(), context.func_195995_a());
        int initialRange = this.isAdvanced() ? ((Integer)ConfigHandler.ADVANCEDRANGE.get()).intValue() : ((Integer)ConfigHandler.BASICRANGE.get()).intValue();
        return this.recursiveTower(context.func_195996_i(), player, block.func_177230_c(), block, context.func_195991_k(), context.func_195995_a(), side, blockStack, initialRange);
    }

    private boolean isAdvanced() {
        return this == SimilsaxRegistry.advanced;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip").func_240699_a_(TextFormatting.GRAY));
    }

    private ActionResultType recursiveTower(ItemStack stack, PlayerEntity player, Block block, BlockState state, World world, BlockPos pos, Direction side, ItemStack blockStack, int range) {
        if (range == 0 || pos == null || side == null || blockStack.func_190926_b()) {
            return ActionResultType.PASS;
        }
        pos = pos.func_177972_a(side);
        BlockState otherState = world.func_180495_p(pos);
        Block otherBlock = otherState.func_177230_c();
        boolean canSkip = this.isAdvanced();
        if (this.canBuildHere(world, pos)) {
            stack.func_222118_a(1, (LivingEntity)player, p -> stack.func_190920_e(0));
            if (!player.func_184812_l_()) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack localStack = player.field_71071_by.func_70301_a(i);
                    if (localStack.func_190926_b() || !localStack.func_77969_a(blockStack)) continue;
                    player.field_71071_by.func_70298_a(i, 1);
                    if (player.field_71070_bA == null) break;
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            world.func_175656_a(pos, state);
            world.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, block.getSoundType(state, (IWorldReader)world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 0.5f, 0.5f);
            return ActionResultType.SUCCESS;
        }
        if (canSkip || this.doBlocksMatch(block, otherBlock)) {
            return this.recursiveTower(stack, player, block, state, world, pos, side, blockStack, range - 1);
        }
        return ActionResultType.PASS;
    }

    private boolean canBuildHere(World world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    private boolean doBlocksMatch(Block block, Block otherBlock) {
        return block == otherBlock;
    }

    public static Direction getSide(Direction sideIn, Vector3d vec, BlockPos pos) {
        boolean rightCorner;
        int[] sides;
        double right;
        double left;
        int side = sideIn.ordinal();
        double xIn = vec.field_72450_a - (double)pos.func_177958_n();
        double yIn = vec.field_72448_b - (double)pos.func_177956_o();
        double zIn = vec.field_72449_c - (double)pos.func_177952_p();
        int centeredSides = 0;
        if (side != 0 && side != 1) {
            centeredSides += yIn > 0.25 && yIn < 0.75 ? 1 : 0;
        }
        if (side != 2 && side != 3) {
            centeredSides += zIn > 0.25 && zIn < 0.75 ? 1 : 0;
        }
        if (side != 4 && side != 5) {
            centeredSides += xIn > 0.25 && xIn < 0.75 ? 1 : 0;
        }
        if (centeredSides == 2) {
            return Direction.values()[side].func_176734_d();
        }
        switch (sideIn) {
            case DOWN: 
            case UP: {
                left = zIn;
                right = xIn;
                sides = sidesZX;
                break;
            }
            case NORTH: 
            case SOUTH: {
                left = xIn;
                right = yIn;
                sides = sidesXY;
                break;
            }
            case WEST: 
            case EAST: {
                left = yIn;
                right = zIn;
                sides = sidesYZ;
                break;
            }
            default: {
                return Direction.UP;
            }
        }
        double cutoff = 0.25;
        boolean leftCorner = left < cutoff || left > 1.0 - cutoff;
        boolean bl = rightCorner = right < cutoff || right > 1.0 - cutoff;
        if (leftCorner && rightCorner) {
            return null;
        }
        boolean b0 = left > right;
        boolean b1 = left > 1.0 - right;
        int result = 0;
        result = b0 && b1 ? sides[0] : (!b0 && !b1 ? sides[1] : (b1 ? sides[2] : sides[3]));
        return Direction.values()[result].func_176734_d();
    }
}

