/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.vorquel.similsaxtranstructors.ItemSimilsax;
import com.vorquel.similsaxtranstructors.client.OverlayRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockOverlay {
    private final ResourceLocation overlayLocation = new ResourceLocation("similsaxtranstructors", "textures/overlay.png");
    private final Vector3d[] vs = new Vector3d[8];
    int arrow1;
    int arrow2;
    int arrow3;
    int arrow4;
    int cross;
    int bullseye;
    int cancel;
    private final float[][][] uvs;

    public BlockOverlay() {
        for (int i = 0; i < 8; ++i) {
            boolean x = (i & 1) == 1;
            boolean y = (i & 2) == 2;
            boolean z = (i & 4) == 4;
            this.vs[i] = new Vector3d((double)x, (double)y, (double)z);
        }
        this.arrow1 = 0;
        this.arrow2 = 1;
        this.arrow3 = 2;
        this.arrow4 = 3;
        this.cross = 4;
        this.bullseye = 5;
        this.cancel = 6;
        this.uvs = new float[7][4][];
        this.uvs[this.arrow1][0] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow1][1] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow1][2] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow1][3] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow2][0] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow2][1] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow2][2] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow2][3] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow3][0] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow3][1] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow3][2] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow3][3] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow4][0] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow4][1] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow4][2] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow4][3] = new float[]{0.5f, 0.5f};
        this.uvs[this.cross][0] = new float[]{0.5f, 0.0f};
        this.uvs[this.cross][1] = new float[]{0.5f, 0.5f};
        this.uvs[this.cross][2] = new float[]{1.0f, 0.5f};
        this.uvs[this.cross][3] = new float[]{1.0f, 0.0f};
        this.uvs[this.bullseye][0] = new float[]{0.0f, 0.5f};
        this.uvs[this.bullseye][1] = new float[]{0.0f, 1.0f};
        this.uvs[this.bullseye][2] = new float[]{0.5f, 1.0f};
        this.uvs[this.bullseye][3] = new float[]{0.5f, 0.5f};
        this.uvs[this.cancel][0] = new float[]{0.5f, 0.5f};
        this.uvs[this.cancel][1] = new float[]{0.5f, 1.0f};
        this.uvs[this.cancel][2] = new float[]{1.0f, 1.0f};
        this.uvs[this.cancel][3] = new float[]{1.0f, 0.5f};
    }

    @SubscribeEvent
    public void renderOverlay(DrawHighlightEvent.HighlightBlock event) {
        if (this.shouldSkip(event)) {
            return;
        }
        BlockRayTraceResult result = event.getTarget();
        MatrixStack matrixStack = event.getMatrix();
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        BlockPos blockPos = new BlockPos((Vector3i)result.func_216350_a());
        Vector3d hitVec = result.func_216347_e();
        int[] look = new int[6];
        if (this.isBadBlock(event)) {
            Direction indexd = Direction.UP;
            look = new int[]{this.cancel, this.cancel, this.cancel, this.cancel, this.cancel, this.cancel};
        } else {
            Direction indexd = ItemSimilsax.getSide(result.func_216354_b(), hitVec, blockPos);
            if (indexd == null) {
                return;
            }
            indexd = indexd.func_176734_d();
            switch (indexd) {
                case DOWN: {
                    look = new int[]{this.arrow3, this.bullseye, this.arrow2, this.arrow2, this.cross, this.arrow3};
                    break;
                }
                case UP: {
                    look = new int[]{this.arrow1, this.cross, this.arrow4, this.arrow4, this.bullseye, this.arrow1};
                    break;
                }
                case NORTH: {
                    look = new int[]{this.arrow2, this.arrow3, this.bullseye, this.arrow3, this.arrow2, this.cross};
                    break;
                }
                case SOUTH: {
                    look = new int[]{this.arrow4, this.arrow1, this.cross, this.arrow1, this.arrow4, this.bullseye};
                    break;
                }
                case WEST: {
                    look = new int[]{this.bullseye, this.arrow2, this.arrow3, this.cross, this.arrow3, this.arrow2};
                    break;
                }
                case EAST: {
                    look = new int[]{this.cross, this.arrow4, this.arrow1, this.bullseye, this.arrow1, this.arrow4};
                    break;
                }
            }
        }
        matrixStack.func_227860_a_();
        RenderType renderType = OverlayRenderType.overlayRenderer(this.overlayLocation);
        IVertexBuilder builder = renderTypeBuffer.getBuffer(renderType);
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        double yDiff = hitVec.field_72448_b - (double)blockPos.func_177956_o();
        if (yDiff > 0.75 && yDiff < 0.25) {
            return;
        }
        matrixStack.func_227861_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        float P = 0.00390625f;
        float N = -0.00390625f;
        boolean X = true;
        int Y = 2;
        int Z = 4;
        int TOP = 1;
        int EAST = 0;
        int SOUTH = 2;
        int WEST = 3;
        int BOTTOM = 4;
        int NORTH = 5;
        matrixStack.func_227861_a_(0.00390625, 0.0, 0.0);
        this.drawSide(builder, matrixStack.func_227866_c_().func_227870_a_(), 1, 2, 4, this.uvs[look[EAST]]);
        matrixStack.func_227861_a_(-0.00390625, 0.00390625, 0.0);
        this.drawSide(builder, matrixStack.func_227866_c_().func_227870_a_(), 2, 4, 1, this.uvs[look[TOP]]);
        matrixStack.func_227861_a_(0.0, -0.00390625, 0.00390625);
        this.drawSide(builder, matrixStack.func_227866_c_().func_227870_a_(), 4, 1, 2, this.uvs[look[SOUTH]]);
        matrixStack.func_227861_a_(-0.00390625, 0.0, -0.00390625);
        this.drawSide(builder, matrixStack.func_227866_c_().func_227870_a_(), 0, 4, 2, this.uvs[look[WEST]]);
        matrixStack.func_227861_a_(0.00390625, -0.00390625, 0.0);
        this.drawSide(builder, matrixStack.func_227866_c_().func_227870_a_(), 0, 1, 4, this.uvs[look[BOTTOM]]);
        matrixStack.func_227861_a_(0.0, 0.00390625, -0.00390625);
        this.drawSide(builder, matrixStack.func_227866_c_().func_227870_a_(), 0, 2, 1, this.uvs[look[NORTH]]);
        renderTypeBuffer.func_228462_a_(renderType);
        matrixStack.func_227865_b_();
    }

    private boolean shouldSkip(DrawHighlightEvent.HighlightBlock event) {
        if (event.getTarget().func_216346_c() != RayTraceResult.Type.BLOCK) {
            return true;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ItemStack mainItemStack = player.func_184586_b(Hand.MAIN_HAND);
            Item mainItem = mainItemStack.func_190926_b() ? null : mainItemStack.func_77973_b();
            ItemStack offItemStack = player.func_184586_b(Hand.OFF_HAND);
            Item offItem = offItemStack.func_190926_b() ? null : offItemStack.func_77973_b();
            return !(mainItem instanceof ItemSimilsax) && !(offItem instanceof ItemSimilsax);
        }
        return true;
    }

    private boolean isBadBlock(DrawHighlightEvent.HighlightBlock event) {
        return false;
    }

    private void drawSide(IVertexBuilder buffer, Matrix4f matrix, int c, int i, int j, float[][] uv) {
        this.addVertex(buffer, matrix, uv[0][0], uv[0][1], c);
        this.addVertex(buffer, matrix, uv[1][0], uv[1][1], c + i);
        this.addVertex(buffer, matrix, uv[2][0], uv[2][1], c + i + j);
        this.addVertex(buffer, matrix, uv[3][0], uv[3][1], c + j);
    }

    private void addVertex(IVertexBuilder buffer, Matrix4f matrix, double u, double v, int i) {
        buffer.func_227888_a_(matrix, (float)this.vs[i].field_72450_a, (float)this.vs[i].field_72448_b, (float)this.vs[i].field_72449_c).func_227885_a_(1.0f, 1.0f, 1.0f, 0.375f).func_225583_a_((float)u, (float)v).func_181675_d();
    }
}

