/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors;

import com.vorquel.similsaxtranstructors.ConfigHandler;
import com.vorquel.similsaxtranstructors.SimilsaxRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemSimilsax
extends Item {
    private static final int[] sidesXY = new int[]{4, 5, 0, 1};
    private static final int[] sidesYZ = new int[]{0, 1, 2, 3};
    private static final int[] sidesZX = new int[]{2, 3, 4, 5};
    public static final float LO = 0.25f;
    public static final float HI = 0.75f;

    public ItemSimilsax(Item.Properties properties) {
        super(properties.m_41491_(CreativeModeTab.f_40756_));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        BlockState block = context.m_43725_().m_8055_(context.m_8083_());
        ItemStack blockStack = new ItemStack((ItemLike)block.m_60734_());
        if (!player.m_7500_() && !player.m_150109_().m_36063_(blockStack)) {
            return InteractionResult.PASS;
        }
        Direction side = ItemSimilsax.getSide(context.m_43719_(), context.m_43720_(), context.m_8083_());
        int initialRange = this.isAdvanced() ? (Integer)ConfigHandler.ADVANCEDRANGE.get() : (Integer)ConfigHandler.BASICRANGE.get();
        return this.recursiveTower(context.m_43722_(), player, block.m_60734_(), block, context.m_43725_(), context.m_8083_(), side, blockStack, initialRange);
    }

    private boolean isAdvanced() {
        return this == SimilsaxRegistry.advanced;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip").m_130940_(ChatFormatting.GRAY));
    }

    private InteractionResult recursiveTower(ItemStack stack, Player player, Block block, BlockState state, Level world, BlockPos pos, Direction side, ItemStack blockStack, int range) {
        if (range == 0 || pos == null || side == null || blockStack.m_41619_()) {
            return InteractionResult.PASS;
        }
        pos = pos.m_142300_(side);
        BlockState otherState = world.m_8055_(pos);
        Block otherBlock = otherState.m_60734_();
        boolean canSkip = this.isAdvanced();
        if (this.canBuildHere(world, pos)) {
            stack.m_41622_(1, (LivingEntity)player, p -> stack.m_41764_(0));
            if (!player.m_7500_()) {
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack localStack = player.m_150109_().m_8020_(i);
                    if (localStack.m_41619_() || !localStack.m_41656_(blockStack)) continue;
                    player.m_150109_().m_7407_(i, 1);
                    if (player.f_36096_ == null) break;
                    player.f_36096_.m_38946_();
                    break;
                }
            }
            world.m_46597_(pos, state);
            world.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, block.getSoundType(state, (LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 0.5f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        if (canSkip || this.doBlocksMatch(block, otherBlock)) {
            return this.recursiveTower(stack, player, block, state, world, pos, side, blockStack, range - 1);
        }
        return InteractionResult.PASS;
    }

    private boolean canBuildHere(Level world, BlockPos pos) {
        return world.m_46859_(pos);
    }

    private boolean doBlocksMatch(Block block, Block otherBlock) {
        return block == otherBlock;
    }

    public static Direction getSide(Direction sideIn, Vec3 vec, BlockPos pos) {
        boolean rightCorner;
        int[] sides;
        double right;
        double left;
        int side = sideIn.ordinal();
        double xIn = vec.f_82479_ - (double)pos.m_123341_();
        double yIn = vec.f_82480_ - (double)pos.m_123342_();
        double zIn = vec.f_82481_ - (double)pos.m_123343_();
        int centeredSides = 0;
        if (side != 0 && side != 1) {
            centeredSides += yIn > 0.25 && yIn < 0.75 ? 1 : 0;
        }
        if (side != 2 && side != 3) {
            centeredSides += zIn > 0.25 && zIn < 0.75 ? 1 : 0;
        }
        if (side != 4 && side != 5) {
            centeredSides += xIn > 0.25 && xIn < 0.75 ? 1 : 0;
        }
        if (centeredSides == 2) {
            return Direction.values()[side].m_122424_();
        }
        switch (sideIn) {
            case DOWN: 
            case UP: {
                left = zIn;
                right = xIn;
                sides = sidesZX;
                break;
            }
            case NORTH: 
            case SOUTH: {
                left = xIn;
                right = yIn;
                sides = sidesXY;
                break;
            }
            case WEST: 
            case EAST: {
                left = yIn;
                right = zIn;
                sides = sidesYZ;
                break;
            }
            default: {
                return Direction.UP;
            }
        }
        double cutoff = 0.25;
        boolean leftCorner = left < cutoff || left > 1.0 - cutoff;
        boolean bl = rightCorner = right < cutoff || right > 1.0 - cutoff;
        if (leftCorner && rightCorner) {
            return null;
        }
        boolean b0 = left > right;
        boolean b1 = left > 1.0 - right;
        int result = 0;
        result = b0 && b1 ? sides[0] : (!b0 && !b1 ? sides[1] : (b1 ? sides[2] : sides[3]));
        return Direction.values()[result].m_122424_();
    }
}

