/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.vorquel.similsaxtranstructors.ItemSimilsax;
import com.vorquel.similsaxtranstructors.client.OverlayRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockOverlay {
    private final ResourceLocation overlayLocation = new ResourceLocation("similsaxtranstructors", "textures/overlay.png");
    private final Vec3[] vs = new Vec3[8];
    int arrow1;
    int arrow2;
    int arrow3;
    int arrow4;
    int cross;
    int bullseye;
    int cancel;
    private final float[][][] uvs;

    public BlockOverlay() {
        for (int i = 0; i < 8; ++i) {
            boolean x = (i & 1) == 1;
            boolean y = (i & 2) == 2;
            boolean z = (i & 4) == 4;
            this.vs[i] = new Vec3((double)x, (double)y, (double)z);
        }
        this.arrow1 = 0;
        this.arrow2 = 1;
        this.arrow3 = 2;
        this.arrow4 = 3;
        this.cross = 4;
        this.bullseye = 5;
        this.cancel = 6;
        this.uvs = new float[7][4][];
        this.uvs[this.arrow1][0] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow1][1] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow1][2] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow1][3] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow2][0] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow2][1] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow2][2] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow2][3] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow3][0] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow3][1] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow3][2] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow3][3] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow4][0] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow4][1] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow4][2] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow4][3] = new float[]{0.5f, 0.5f};
        this.uvs[this.cross][0] = new float[]{0.5f, 0.0f};
        this.uvs[this.cross][1] = new float[]{0.5f, 0.5f};
        this.uvs[this.cross][2] = new float[]{1.0f, 0.5f};
        this.uvs[this.cross][3] = new float[]{1.0f, 0.0f};
        this.uvs[this.bullseye][0] = new float[]{0.0f, 0.5f};
        this.uvs[this.bullseye][1] = new float[]{0.0f, 1.0f};
        this.uvs[this.bullseye][2] = new float[]{0.5f, 1.0f};
        this.uvs[this.bullseye][3] = new float[]{0.5f, 0.5f};
        this.uvs[this.cancel][0] = new float[]{0.5f, 0.5f};
        this.uvs[this.cancel][1] = new float[]{0.5f, 1.0f};
        this.uvs[this.cancel][2] = new float[]{1.0f, 1.0f};
        this.uvs[this.cancel][3] = new float[]{1.0f, 0.5f};
    }

    @SubscribeEvent
    public void renderOverlay(DrawSelectionEvent.HighlightBlock event) {
        if (this.shouldSkip(event)) {
            return;
        }
        BlockHitResult result = event.getTarget();
        PoseStack matrixStack = event.getMatrix();
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BlockPos blockPos = new BlockPos((Vec3i)result.m_82425_());
        Vec3 hitVec = result.m_82450_();
        int[] look = new int[6];
        if (this.isBadBlock(event)) {
            Direction indexd = Direction.UP;
            look = new int[]{this.cancel, this.cancel, this.cancel, this.cancel, this.cancel, this.cancel};
        } else {
            Direction indexd = ItemSimilsax.getSide(result.m_82434_(), hitVec, blockPos);
            if (indexd == null) {
                return;
            }
            indexd = indexd.m_122424_();
            switch (indexd) {
                case DOWN: {
                    look = new int[]{this.arrow3, this.bullseye, this.arrow2, this.arrow2, this.cross, this.arrow3};
                    break;
                }
                case UP: {
                    look = new int[]{this.arrow1, this.cross, this.arrow4, this.arrow4, this.bullseye, this.arrow1};
                    break;
                }
                case NORTH: {
                    look = new int[]{this.arrow2, this.arrow3, this.bullseye, this.arrow3, this.arrow2, this.cross};
                    break;
                }
                case SOUTH: {
                    look = new int[]{this.arrow4, this.arrow1, this.cross, this.arrow1, this.arrow4, this.bullseye};
                    break;
                }
                case WEST: {
                    look = new int[]{this.bullseye, this.arrow2, this.arrow3, this.cross, this.arrow3, this.arrow2};
                    break;
                }
                case EAST: {
                    look = new int[]{this.cross, this.arrow4, this.arrow1, this.bullseye, this.arrow1, this.arrow4};
                    break;
                }
            }
        }
        matrixStack.m_85836_();
        RenderType renderType = OverlayRenderType.overlayRenderer(this.overlayLocation);
        VertexConsumer builder = renderTypeBuffer.m_6299_(renderType);
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        double yDiff = hitVec.f_82480_ - (double)blockPos.m_123342_();
        if (yDiff > 0.75 && yDiff < 0.25) {
            return;
        }
        matrixStack.m_85837_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        float P = 0.00390625f;
        float N = -0.00390625f;
        boolean X = true;
        int Y = 2;
        int Z = 4;
        int TOP = 1;
        int EAST = 0;
        int SOUTH = 2;
        int WEST = 3;
        int BOTTOM = 4;
        int NORTH = 5;
        matrixStack.m_85837_(0.00390625, 0.0, 0.0);
        this.drawSide(builder, matrixStack.m_85850_().m_85861_(), 1, 2, 4, this.uvs[look[EAST]]);
        matrixStack.m_85837_(-0.00390625, 0.00390625, 0.0);
        this.drawSide(builder, matrixStack.m_85850_().m_85861_(), 2, 4, 1, this.uvs[look[TOP]]);
        matrixStack.m_85837_(0.0, -0.00390625, 0.00390625);
        this.drawSide(builder, matrixStack.m_85850_().m_85861_(), 4, 1, 2, this.uvs[look[SOUTH]]);
        matrixStack.m_85837_(-0.00390625, 0.0, -0.00390625);
        this.drawSide(builder, matrixStack.m_85850_().m_85861_(), 0, 4, 2, this.uvs[look[WEST]]);
        matrixStack.m_85837_(0.00390625, -0.00390625, 0.0);
        this.drawSide(builder, matrixStack.m_85850_().m_85861_(), 0, 1, 4, this.uvs[look[BOTTOM]]);
        matrixStack.m_85837_(0.0, 0.00390625, -0.00390625);
        this.drawSide(builder, matrixStack.m_85850_().m_85861_(), 0, 2, 1, this.uvs[look[NORTH]]);
        renderTypeBuffer.m_109912_(renderType);
        matrixStack.m_85849_();
    }

    private boolean shouldSkip(DrawSelectionEvent.HighlightBlock event) {
        if (event.getTarget().m_6662_() != HitResult.Type.BLOCK) {
            return true;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack mainItemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item mainItem = mainItemStack.m_41619_() ? null : mainItemStack.m_41720_();
            ItemStack offItemStack = player.m_21120_(InteractionHand.OFF_HAND);
            Item offItem = offItemStack.m_41619_() ? null : offItemStack.m_41720_();
            return !(mainItem instanceof ItemSimilsax) && !(offItem instanceof ItemSimilsax);
        }
        return true;
    }

    private boolean isBadBlock(DrawSelectionEvent.HighlightBlock event) {
        return false;
    }

    private void drawSide(VertexConsumer buffer, Matrix4f matrix, int c, int i, int j, float[][] uv) {
        this.addVertex(buffer, matrix, uv[0][0], uv[0][1], c);
        this.addVertex(buffer, matrix, uv[1][0], uv[1][1], c + i);
        this.addVertex(buffer, matrix, uv[2][0], uv[2][1], c + i + j);
        this.addVertex(buffer, matrix, uv[3][0], uv[3][1], c + j);
    }

    private void addVertex(VertexConsumer buffer, Matrix4f matrix, double u, double v, int i) {
        buffer.m_85982_(matrix, (float)this.vs[i].f_82479_, (float)this.vs[i].f_82480_, (float)this.vs[i].f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 0.375f).m_7421_((float)u, (float)v).m_5752_();
    }
}

