/*
 * Decompiled with CFR 0.152.
 */
package vorquel.mod.similsaxtranstructors;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import vorquel.mod.similsaxtranstructors.ItemSimilsaxTranstructor;

public class BlockOverlay {
    private final ResourceLocation overlayLocation = new ResourceLocation("SimilsaxTranstructors".toLowerCase(), "textures/overlay.png");
    private final Vec3d[] vs = new Vec3d[8];
    private final float[][][] uvs;
    private final int[][] lookUps;

    public BlockOverlay() {
        for (int i = 0; i < 8; ++i) {
            boolean x = (i & 1) == 1;
            boolean y = (i & 2) == 2;
            boolean z = (i & 4) == 4;
            this.vs[i] = new Vec3d((double)x, (double)y, (double)z);
        }
        this.uvs = new float[7][4][];
        this.uvs[0][0] = new float[]{0.0f, 0.0f};
        this.uvs[0][1] = new float[]{0.0f, 0.5f};
        this.uvs[0][2] = new float[]{0.5f, 0.5f};
        this.uvs[0][3] = new float[]{0.5f, 0.0f};
        this.uvs[1][0] = new float[]{0.0f, 0.5f};
        this.uvs[1][1] = new float[]{0.5f, 0.5f};
        this.uvs[1][2] = new float[]{0.5f, 0.0f};
        this.uvs[1][3] = new float[]{0.0f, 0.0f};
        this.uvs[2][0] = new float[]{0.5f, 0.5f};
        this.uvs[2][1] = new float[]{0.5f, 0.0f};
        this.uvs[2][2] = new float[]{0.0f, 0.0f};
        this.uvs[2][3] = new float[]{0.0f, 0.5f};
        this.uvs[3][0] = new float[]{0.5f, 0.0f};
        this.uvs[3][1] = new float[]{0.0f, 0.0f};
        this.uvs[3][2] = new float[]{0.0f, 0.5f};
        this.uvs[3][3] = new float[]{0.5f, 0.5f};
        this.uvs[4][0] = new float[]{0.5f, 0.0f};
        this.uvs[4][1] = new float[]{0.5f, 0.5f};
        this.uvs[4][2] = new float[]{1.0f, 0.5f};
        this.uvs[4][3] = new float[]{1.0f, 0.0f};
        this.uvs[5][0] = new float[]{0.0f, 0.5f};
        this.uvs[5][1] = new float[]{0.0f, 1.0f};
        this.uvs[5][2] = new float[]{0.5f, 1.0f};
        this.uvs[5][3] = new float[]{0.5f, 0.5f};
        this.uvs[6][0] = new float[]{0.5f, 0.5f};
        this.uvs[6][1] = new float[]{0.5f, 1.0f};
        this.uvs[6][2] = new float[]{1.0f, 1.0f};
        this.uvs[6][3] = new float[]{1.0f, 0.5f};
        this.lookUps = new int[7][6];
        this.lookUps[0] = new int[]{2, 5, 1, 1, 4, 2};
        this.lookUps[1] = new int[]{0, 4, 3, 3, 5, 0};
        this.lookUps[2] = new int[]{1, 2, 5, 2, 1, 4};
        this.lookUps[3] = new int[]{3, 0, 4, 0, 3, 5};
        this.lookUps[4] = new int[]{5, 1, 2, 4, 2, 1};
        this.lookUps[5] = new int[]{4, 3, 0, 5, 0, 3};
        this.lookUps[6] = new int[]{6, 6, 6, 6, 6, 6};
    }

    @SubscribeEvent
    public void renderOverlay(DrawBlockHighlightEvent event) {
        if (this.shouldSkip(event)) {
            return;
        }
        RayTraceResult m = event.getTarget();
        BlockPos mPos = m.func_178782_a();
        Vec3d h = m.field_72307_f;
        int index = this.isBadBlock(event) ? 6 : ItemSimilsaxTranstructor.getSide(m.field_178784_b.func_176745_a(), h.field_72450_a - (double)mPos.func_177958_n(), h.field_72448_b - (double)mPos.func_177956_o(), h.field_72449_c - (double)mPos.func_177952_p());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.overlayLocation);
        Vec3d v = this.getViewerPosition(event.getPartialTicks());
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)mPos.func_177958_n(), (double)mPos.func_177956_o(), (double)mPos.func_177952_p());
        GL11.glTranslated((double)(-v.field_72450_a), (double)(-v.field_72448_b), (double)(-v.field_72449_c));
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.375f);
        float P = 0.00390625f;
        float N = -0.00390625f;
        boolean X = true;
        int Y = 2;
        int Z = 4;
        GL11.glTranslatef((float)0.00390625f, (float)0.0f, (float)0.0f);
        this.drawSide(1, 2, 4, this.uvs[this.lookUps[index][0]]);
        GL11.glTranslatef((float)-0.00390625f, (float)0.00390625f, (float)0.0f);
        this.drawSide(2, 4, 1, this.uvs[this.lookUps[index][1]]);
        GL11.glTranslatef((float)0.0f, (float)-0.00390625f, (float)0.00390625f);
        this.drawSide(4, 1, 2, this.uvs[this.lookUps[index][2]]);
        GL11.glTranslatef((float)-0.00390625f, (float)0.0f, (float)-0.00390625f);
        this.drawSide(0, 4, 2, this.uvs[this.lookUps[index][3]]);
        GL11.glTranslatef((float)0.00390625f, (float)-0.00390625f, (float)0.0f);
        this.drawSide(0, 1, 4, this.uvs[this.lookUps[index][4]]);
        GL11.glTranslatef((float)0.0f, (float)0.00390625f, (float)-0.00390625f);
        this.drawSide(0, 2, 1, this.uvs[this.lookUps[index][5]]);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private boolean shouldSkip(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return true;
        }
        ItemStack mainItemStack = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
        Item mainItem = mainItemStack == null ? null : mainItemStack.func_77973_b();
        ItemStack offItemStack = event.getPlayer().func_184586_b(EnumHand.OFF_HAND);
        Item offItem = offItemStack == null ? null : offItemStack.func_77973_b();
        return !(mainItem instanceof ItemSimilsaxTranstructor) && !(offItem instanceof ItemSimilsaxTranstructor);
    }

    private boolean isBadBlock(DrawBlockHighlightEvent event) {
        World world = event.getPlayer().field_70170_p;
        BlockPos pos = event.getTarget().func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.hasTileEntity(state) || block.func_176200_f((IBlockAccess)world, pos);
    }

    private Vec3d getViewerPosition(float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double x = this.partial(partialTicks, viewer.field_70169_q, viewer.field_70165_t);
        double y = this.partial(partialTicks, viewer.field_70167_r, viewer.field_70163_u);
        double z = this.partial(partialTicks, viewer.field_70166_s, viewer.field_70161_v);
        return new Vec3d(x, y, z);
    }

    private double partial(float partialTicks, double prevPos, double pos) {
        return partialTicks == 1.0f ? pos : prevPos + (double)partialTicks * (pos - prevPos);
    }

    private void drawSide(int c, int i, int j, float[][] uv) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.addVertex(uv[0][0], uv[0][1], c);
        this.addVertex(uv[1][0], uv[1][1], c + i);
        this.addVertex(uv[2][0], uv[2][1], c + i + j);
        this.addVertex(uv[3][0], uv[3][1], c + j);
        Tessellator.func_178181_a().func_78381_a();
    }

    private void addVertex(double u, double v, int i) {
        Tessellator.func_178181_a().func_178180_c().func_181662_b(this.vs[i].field_72450_a, this.vs[i].field_72448_b, this.vs[i].field_72449_c).func_187315_a(u, v).func_181675_d();
    }
}

