/*
 * Decompiled with CFR 0.152.
 */
package vorquel.mod.similsaxtranstructors;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vorquel.mod.similsaxtranstructors.Config;
import vorquel.mod.similsaxtranstructors.ConfigSynchonizer;
import vorquel.mod.similsaxtranstructors.ItemSimilsaxTranstructor;
import vorquel.mod.similsaxtranstructors.Proxy;
import vorquel.mod.similsaxtranstructors.RegistryThing;

@Mod(modid="similsaxtranstructors", name="Similsax Transtructors", updateJSON="https://raw.githubusercontent.com/PrinceOfAmber/Similsax-Transtructors/master/update.json", acceptedMinecraftVersions="[1.12]")
public class SimilsaxTranstructors {
    public static final String MOD_ID = "similsaxtranstructors";
    public static final ItemSimilsaxTranstructor itemBasic = new ItemSimilsaxTranstructor("Basic");
    public static final ItemSimilsaxTranstructor itemAdvanced = new ItemSimilsaxTranstructor("Advanced");
    @SidedProxy(clientSide="vorquel.mod.similsaxtranstructors.ClientProxy", serverSide="vorquel.mod.similsaxtranstructors.Proxy")
    static Proxy proxy;
    static Logger log;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.init(event.getSuggestedConfigurationFile());
        ConfigSynchonizer.init();
        proxy.registerItemModel();
        MinecraftForge.EVENT_BUS.register(RegistryThing.class);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Config.showOverlay) {
            proxy.registerBlockOverlay();
        }
        MinecraftForge.EVENT_BUS.register((Object)new ConfigSynchonizer());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        log.info("Syncing Server configs");
        itemBasic.setUses(Config.basicUses);
        itemAdvanced.setUses(Config.advancedUses);
        SimilsaxTranstructors.itemBasic.range = Config.basicRange;
        SimilsaxTranstructors.itemAdvanced.range = Config.advancedRange;
    }

    static {
        log = LogManager.getLogger((String)MOD_ID);
    }
}

