/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors;

import com.vorquel.similsaxtranstructors.ItemSimilsax;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class BlockOverlay {
    private final ResourceLocation overlayLocation = new ResourceLocation("similsaxtranstructors".toLowerCase(), "textures/overlay.png");
    private final Vec3d[] vs = new Vec3d[8];
    int arrow1;
    int arrow2;
    int arrow3;
    int arrow4;
    int cross;
    int bullseye;
    int cancel;
    private final float[][][] uvs;

    public BlockOverlay() {
        for (int i = 0; i < 8; ++i) {
            boolean x = (i & 1) == 1;
            boolean y = (i & 2) == 2;
            boolean z = (i & 4) == 4;
            this.vs[i] = new Vec3d((double)x, (double)y, (double)z);
        }
        this.arrow1 = 0;
        this.arrow2 = 1;
        this.arrow3 = 2;
        this.arrow4 = 3;
        this.cross = 4;
        this.bullseye = 5;
        this.cancel = 6;
        this.uvs = new float[7][4][];
        this.uvs[this.arrow1][0] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow1][1] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow1][2] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow1][3] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow2][0] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow2][1] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow2][2] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow2][3] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow3][0] = new float[]{0.5f, 0.5f};
        this.uvs[this.arrow3][1] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow3][2] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow3][3] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow4][0] = new float[]{0.5f, 0.0f};
        this.uvs[this.arrow4][1] = new float[]{0.0f, 0.0f};
        this.uvs[this.arrow4][2] = new float[]{0.0f, 0.5f};
        this.uvs[this.arrow4][3] = new float[]{0.5f, 0.5f};
        this.uvs[this.cross][0] = new float[]{0.5f, 0.0f};
        this.uvs[this.cross][1] = new float[]{0.5f, 0.5f};
        this.uvs[this.cross][2] = new float[]{1.0f, 0.5f};
        this.uvs[this.cross][3] = new float[]{1.0f, 0.0f};
        this.uvs[this.bullseye][0] = new float[]{0.0f, 0.5f};
        this.uvs[this.bullseye][1] = new float[]{0.0f, 1.0f};
        this.uvs[this.bullseye][2] = new float[]{0.5f, 1.0f};
        this.uvs[this.bullseye][3] = new float[]{0.5f, 0.5f};
        this.uvs[this.cancel][0] = new float[]{0.5f, 0.5f};
        this.uvs[this.cancel][1] = new float[]{0.5f, 1.0f};
        this.uvs[this.cancel][2] = new float[]{1.0f, 1.0f};
        this.uvs[this.cancel][3] = new float[]{1.0f, 0.5f};
    }

    @SubscribeEvent
    public void renderOverlay(DrawBlockHighlightEvent event) {
        if (this.shouldSkip(event)) {
            return;
        }
        RayTraceResult m = event.getTarget();
        if (m.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction indexd;
            BlockRayTraceResult result = (BlockRayTraceResult)m;
            BlockPos mPos = new BlockPos(m.func_216347_e());
            Vec3d hitVec = m.func_216347_e();
            int index = 6;
            int[] look = new int[6];
            if (this.isBadBlock(event)) {
                indexd = Direction.UP;
                index = 6;
                look = new int[]{this.cancel, this.cancel, this.cancel, this.cancel, this.cancel, this.cancel};
            } else {
                indexd = ItemSimilsax.getSide(result.func_216354_b(), hitVec, mPos);
                if (indexd == null) {
                    return;
                }
                indexd = indexd.func_176734_d();
                index = indexd.ordinal();
                switch (indexd) {
                    case DOWN: {
                        look = new int[]{this.arrow3, this.bullseye, this.arrow2, this.arrow2, this.cross, this.arrow3};
                        break;
                    }
                    case UP: {
                        look = new int[]{this.arrow1, this.cross, this.arrow4, this.arrow4, this.bullseye, this.arrow1};
                        break;
                    }
                    case NORTH: {
                        look = new int[]{this.arrow2, this.arrow3, this.bullseye, this.arrow3, this.arrow2, this.cross};
                        break;
                    }
                    case SOUTH: {
                        look = new int[]{this.arrow4, this.arrow1, this.cross, this.arrow1, this.arrow4, this.bullseye};
                        break;
                    }
                    case WEST: {
                        look = new int[]{this.bullseye, this.arrow2, this.arrow3, this.cross, this.arrow3, this.arrow2};
                        break;
                    }
                    case EAST: {
                        look = new int[]{this.cross, this.arrow4, this.arrow1, this.bullseye, this.arrow1, this.arrow4};
                        break;
                    }
                }
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.overlayLocation);
            Vec3d v = this.getViewerPosition(event.getPartialTicks());
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            double xFix = 0.0;
            double yFix = 0.08;
            double zFix = 0.0;
            double yDiff = hitVec.field_72448_b - (double)mPos.func_177956_o();
            if (yDiff < 0.25) {
                yFix = -1.62;
            } else if (yDiff > 0.75) {
                yFix = -1.62;
            }
            if (result.func_216354_b() == Direction.SOUTH) {
                zFix = -1.0;
            } else if (result.func_216354_b() == Direction.EAST) {
                xFix = -1.0;
            } else if (result.func_216354_b() == Direction.UP) {
                yFix += -1.0;
                if (indexd != Direction.UP) {
                    yFix += 1.7;
                }
            } else if (result.func_216354_b() == Direction.DOWN && indexd != Direction.DOWN) {
                yFix += 1.7;
            }
            GL11.glTranslated((double)((double)mPos.func_177958_n() + xFix), (double)((double)mPos.func_177956_o() + yFix), (double)((double)mPos.func_177952_p() + zFix));
            GL11.glTranslated((double)(-v.field_72450_a), (double)(-v.field_72448_b), (double)(-v.field_72449_c));
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.375f);
            float P = 0.00390625f;
            float N = -0.00390625f;
            boolean X = true;
            int Y = 2;
            int Z = 4;
            if (index >= 2 && index <= 5) {
                GL11.glTranslatef((float)0.0f, (float)-1.7f, (float)0.0f);
            }
            int TOP = 1;
            int EAST = 0;
            int SOUTH = 2;
            int WEST = 3;
            int BOTTOM = 4;
            int NORTH = 5;
            GL11.glTranslatef((float)0.00390625f, (float)0.0f, (float)0.0f);
            this.drawSide(1, 2, 4, this.uvs[look[EAST]]);
            GL11.glTranslatef((float)-0.00390625f, (float)0.00390625f, (float)0.0f);
            this.drawSide(2, 4, 1, this.uvs[look[TOP]]);
            GL11.glTranslatef((float)0.0f, (float)-0.00390625f, (float)0.00390625f);
            this.drawSide(4, 1, 2, this.uvs[look[SOUTH]]);
            GL11.glTranslatef((float)-0.00390625f, (float)0.0f, (float)-0.00390625f);
            this.drawSide(0, 4, 2, this.uvs[look[WEST]]);
            GL11.glTranslatef((float)0.00390625f, (float)-0.00390625f, (float)0.0f);
            this.drawSide(0, 1, 4, this.uvs[look[BOTTOM]]);
            GL11.glTranslatef((float)0.0f, (float)0.00390625f, (float)-0.00390625f);
            this.drawSide(0, 2, 1, this.uvs[look[NORTH]]);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    private boolean shouldSkip(DrawBlockHighlightEvent event) {
        if (event.getTarget().func_216346_c() != RayTraceResult.Type.BLOCK) {
            return true;
        }
        ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
        ItemStack mainItemStack = p.func_184586_b(Hand.MAIN_HAND);
        Item mainItem = mainItemStack.func_190926_b() ? null : mainItemStack.func_77973_b();
        ItemStack offItemStack = p.func_184586_b(Hand.OFF_HAND);
        Item offItem = offItemStack.func_190926_b() ? null : offItemStack.func_77973_b();
        return !(mainItem instanceof ItemSimilsax) && !(offItem instanceof ItemSimilsax);
    }

    private boolean isBadBlock(DrawBlockHighlightEvent event) {
        return false;
    }

    private Vec3d getViewerPosition(float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double x = this.partial(partialTicks, viewer.field_70169_q, viewer.field_70165_t);
        double y = this.partial(partialTicks, viewer.field_70167_r, viewer.field_70163_u);
        double z = this.partial(partialTicks, viewer.field_70166_s, viewer.field_70161_v);
        return new Vec3d(x, y, z);
    }

    private double partial(float partialTicks, double prevPos, double pos) {
        return partialTicks == 1.0f ? pos : prevPos + (double)partialTicks * (pos - prevPos);
    }

    private void drawSide(int c, int i, int j, float[][] uv) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.addVertex(uv[0][0], uv[0][1], c);
        this.addVertex(uv[1][0], uv[1][1], c + i);
        this.addVertex(uv[2][0], uv[2][1], c + i + j);
        this.addVertex(uv[3][0], uv[3][1], c + j);
        Tessellator.func_178181_a().func_78381_a();
    }

    private void addVertex(double u, double v, int i) {
        Tessellator.func_178181_a().func_178180_c().func_181662_b(this.vs[i].field_72450_a, this.vs[i].field_72448_b, this.vs[i].field_72449_c).func_187315_a(u, v).func_181675_d();
    }
}

