/*
 * Decompiled with CFR 0.152.
 */
package com.vorquel.similsaxtranstructors;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemSimilsax
extends Item {
    private static final int range = 32;
    private static final int[] sidesXY = new int[]{4, 5, 0, 1};
    private static final int[] sidesYZ = new int[]{0, 1, 2, 3};
    private static final int[] sidesZX = new int[]{2, 3, 4, 5};
    public static final float lo = 0.25f;
    public static final float hi = 0.75f;

    public ItemSimilsax(Item.Properties properties) {
        super(properties.func_200916_a(ItemGroup.field_78040_i));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockState block = context.func_195991_k().func_180495_p(context.func_195995_a());
        ItemStack blockStack = new ItemStack((IItemProvider)block.func_177230_c());
        if (!player.field_71071_by.func_70431_c(blockStack)) {
            return ActionResultType.PASS;
        }
        Direction side = ItemSimilsax.getSide(context.func_196000_l(), context.func_221532_j(), context.func_195995_a());
        return this.tower(context.func_195996_i(), context.func_195999_j(), block.func_177230_c(), block, context.func_195991_k(), context.func_195995_a(), side, blockStack);
    }

    private ActionResultType tower(ItemStack stack, PlayerEntity player, Block block, BlockState state, World world, BlockPos pos, Direction side, ItemStack blockStack) {
        return this.tower(stack, player, block, state, world, pos, side, blockStack, 32);
    }

    private ActionResultType tower(ItemStack stack, PlayerEntity player, Block block, BlockState state, World world, BlockPos pos, Direction side, ItemStack blockStack, int range) {
        if (range == 0 || pos == null || side == null) {
            return ActionResultType.PASS;
        }
        BlockState otherState = world.func_180495_p(pos = pos.func_177972_a(side));
        Block otherBlock = otherState.func_177230_c();
        if (block == otherBlock) {
            return this.tower(stack, player, block, state, world, pos, side, blockStack, range - 1);
        }
        if (world.func_175623_d(pos)) {
            stack.func_222118_a(1, (LivingEntity)player, p -> {});
            if (stack.func_190916_E() == 0) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (!player.func_184812_l_()) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack localStack = player.field_71071_by.func_70301_a(i);
                    if (localStack.func_190926_b() || !localStack.func_77969_a(blockStack)) continue;
                    player.field_71071_by.func_70298_a(i, 1);
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            world.func_175656_a(pos, state);
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, block.getSoundType(state, (IWorldReader)world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 0.5f, 0.5f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static Direction getSide(Direction sideIn, Vec3d vec, BlockPos pos) {
        boolean rightCorner;
        int[] sides;
        double right;
        double left;
        int side = sideIn.ordinal();
        double xIn = vec.field_72450_a - (double)pos.func_177958_n();
        double yIn = vec.field_72448_b - (double)pos.func_177956_o();
        double zIn = vec.field_72449_c - (double)pos.func_177952_p();
        int centeredSides = 0;
        if (side != 0 && side != 1) {
            centeredSides += yIn > 0.25 && yIn < 0.75 ? 1 : 0;
        }
        if (side != 2 && side != 3) {
            centeredSides += zIn > 0.25 && zIn < 0.75 ? 1 : 0;
        }
        if (side != 4 && side != 5) {
            centeredSides += xIn > 0.25 && xIn < 0.75 ? 1 : 0;
        }
        if (centeredSides == 2) {
            return Direction.values()[side].func_176734_d();
        }
        switch (sideIn) {
            case DOWN: 
            case UP: {
                left = zIn;
                right = xIn;
                sides = sidesZX;
                break;
            }
            case NORTH: 
            case SOUTH: {
                left = xIn;
                right = yIn;
                sides = sidesXY;
                break;
            }
            case WEST: 
            case EAST: {
                left = yIn;
                right = zIn;
                sides = sidesYZ;
                break;
            }
            default: {
                return Direction.UP;
            }
        }
        double cutoff = 0.25;
        boolean leftCorner = left < cutoff || left > 1.0 - cutoff;
        boolean bl = rightCorner = right < cutoff || right > 1.0 - cutoff;
        if (leftCorner && rightCorner) {
            return null;
        }
        boolean b0 = left > right;
        boolean b1 = left > 1.0 - right;
        int result = 0;
        result = b0 && b1 ? sides[0] : (!b0 && !b1 ? sides[1] : (b1 ? sides[2] : sides[3]));
        return Direction.values()[result].func_176734_d();
    }
}

