/*
 * Decompiled with CFR 0.152.
 */
package vorquel.mod.similsaxtranstructors;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import org.lwjgl.opengl.GL11;
import vorquel.mod.similsaxtranstructors.ItemSimilsaxTranstructor;

public class BlockOverlay {
    private final ResourceLocation overlayLocation = new ResourceLocation("SimilsaxTranstructors".toLowerCase(), "textures/overlay.png");
    private final Vec3[] vs = new Vec3[8];
    private final float[][][] uvs;
    private final int[][] lookUps;

    public BlockOverlay() {
        for (int i = 0; i < 8; ++i) {
            this.vs[i] = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            this.vs[i].field_72450_a = (i & 1) == 1 ? 1.0 : 0.0;
            this.vs[i].field_72448_b = (i & 2) == 2 ? 1.0 : 0.0;
            this.vs[i].field_72449_c = (i & 4) == 4 ? 1.0 : 0.0;
        }
        this.uvs = new float[7][4][];
        this.uvs[0][0] = new float[]{0.0f, 0.0f};
        this.uvs[0][1] = new float[]{0.0f, 0.5f};
        this.uvs[0][2] = new float[]{0.5f, 0.5f};
        this.uvs[0][3] = new float[]{0.5f, 0.0f};
        this.uvs[1][0] = new float[]{0.0f, 0.5f};
        this.uvs[1][1] = new float[]{0.5f, 0.5f};
        this.uvs[1][2] = new float[]{0.5f, 0.0f};
        this.uvs[1][3] = new float[]{0.0f, 0.0f};
        this.uvs[2][0] = new float[]{0.5f, 0.5f};
        this.uvs[2][1] = new float[]{0.5f, 0.0f};
        this.uvs[2][2] = new float[]{0.0f, 0.0f};
        this.uvs[2][3] = new float[]{0.0f, 0.5f};
        this.uvs[3][0] = new float[]{0.5f, 0.0f};
        this.uvs[3][1] = new float[]{0.0f, 0.0f};
        this.uvs[3][2] = new float[]{0.0f, 0.5f};
        this.uvs[3][3] = new float[]{0.5f, 0.5f};
        this.uvs[4][0] = new float[]{0.5f, 0.0f};
        this.uvs[4][1] = new float[]{0.5f, 0.5f};
        this.uvs[4][2] = new float[]{1.0f, 0.5f};
        this.uvs[4][3] = new float[]{1.0f, 0.0f};
        this.uvs[5][0] = new float[]{0.0f, 0.5f};
        this.uvs[5][1] = new float[]{0.0f, 1.0f};
        this.uvs[5][2] = new float[]{0.5f, 1.0f};
        this.uvs[5][3] = new float[]{0.5f, 0.5f};
        this.uvs[6][0] = new float[]{0.5f, 0.5f};
        this.uvs[6][1] = new float[]{0.5f, 1.0f};
        this.uvs[6][2] = new float[]{1.0f, 1.0f};
        this.uvs[6][3] = new float[]{1.0f, 0.5f};
        this.lookUps = new int[7][6];
        this.lookUps[0] = new int[]{2, 5, 1, 1, 4, 2};
        this.lookUps[1] = new int[]{0, 4, 3, 3, 5, 0};
        this.lookUps[2] = new int[]{1, 2, 5, 2, 1, 4};
        this.lookUps[3] = new int[]{3, 0, 4, 0, 3, 5};
        this.lookUps[4] = new int[]{5, 1, 2, 4, 2, 1};
        this.lookUps[5] = new int[]{4, 3, 0, 5, 0, 3};
        this.lookUps[6] = new int[]{6, 6, 6, 6, 6, 6};
    }

    @SubscribeEvent
    public void renderOverlay(DrawBlockHighlightEvent event) {
        if (this.shouldSkip(event)) {
            return;
        }
        MovingObjectPosition m = event.target;
        Vec3 h = m.field_72307_f;
        int index = this.isBadBlock(event) ? 6 : ItemSimilsaxTranstructor.getSide(m.field_72310_e, h.field_72450_a - (double)m.field_72311_b, h.field_72448_b - (double)m.field_72312_c, h.field_72449_c - (double)m.field_72309_d);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.overlayLocation);
        Vec3 v = Minecraft.func_71410_x().field_71451_h.func_70666_h(event.partialTicks);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)m.field_72311_b, (double)m.field_72312_c, (double)m.field_72309_d);
        GL11.glTranslated((double)(-v.field_72450_a), (double)(-v.field_72448_b), (double)(-v.field_72449_c));
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.375f);
        float P = 0.00390625f;
        float N = -0.00390625f;
        boolean X = true;
        int Y = 2;
        int Z = 4;
        GL11.glTranslatef((float)0.00390625f, (float)0.0f, (float)0.0f);
        this.drawSide(1, 2, 4, this.uvs[this.lookUps[index][0]]);
        GL11.glTranslatef((float)-0.00390625f, (float)0.00390625f, (float)0.0f);
        this.drawSide(2, 4, 1, this.uvs[this.lookUps[index][1]]);
        GL11.glTranslatef((float)0.0f, (float)-0.00390625f, (float)0.00390625f);
        this.drawSide(4, 1, 2, this.uvs[this.lookUps[index][2]]);
        GL11.glTranslatef((float)-0.00390625f, (float)0.0f, (float)-0.00390625f);
        this.drawSide(0, 4, 2, this.uvs[this.lookUps[index][3]]);
        GL11.glTranslatef((float)0.00390625f, (float)-0.00390625f, (float)0.0f);
        this.drawSide(0, 1, 4, this.uvs[this.lookUps[index][4]]);
        GL11.glTranslatef((float)0.0f, (float)0.00390625f, (float)-0.00390625f);
        this.drawSide(0, 2, 1, this.uvs[this.lookUps[index][5]]);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private boolean shouldSkip(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return true;
        }
        if (event.currentItem == null) {
            return true;
        }
        return !(event.currentItem.func_77973_b() instanceof ItemSimilsaxTranstructor);
    }

    private boolean isBadBlock(DrawBlockHighlightEvent event) {
        int meta;
        World world = event.player.field_70170_p;
        int x = event.target.field_72311_b;
        int y = event.target.field_72312_c;
        int z = event.target.field_72309_d;
        Block block = world.func_147439_a(x, y, z);
        return block.hasTileEntity(meta = world.func_72805_g(x, y, z)) || block.isReplaceable((IBlockAccess)world, x, y, z);
    }

    private void drawSide(int c, int i, int j, float[][] uv) {
        Tessellator.field_78398_a.func_78382_b();
        this.addVertex(uv[0][0], uv[0][1], c);
        this.addVertex(uv[1][0], uv[1][1], c + i);
        this.addVertex(uv[2][0], uv[2][1], c + i + j);
        this.addVertex(uv[3][0], uv[3][1], c + j);
        Tessellator.field_78398_a.func_78381_a();
    }

    private void addVertex(double u, double v, int i) {
        Tessellator.field_78398_a.func_78374_a(this.vs[i].field_72450_a, this.vs[i].field_72448_b, this.vs[i].field_72449_c, u, v);
    }
}

