/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.CopyBackpackDataRecipe;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.FilterGui;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.gui.SBGui;
import com.flanks255.simplybackpacks.items.ItemBackpackBase;
import com.flanks255.simplybackpacks.network.OpenMessage;
import com.flanks255.simplybackpacks.network.SBNetwork;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simplybackpacks")
public class SimplyBackpacks {
    public static final String MODID = "simplybackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"simplybackpacks");
    public static SimpleChannel network;
    public static SBNetwork sbnetwork;
    public static final ItemBackpackBase commonBackpack;
    public static final ItemBackpackBase uncommonBackpack;
    public static final ItemBackpackBase rareBackpack;
    public static final ItemBackpackBase epicBackpack;
    private NonNullList<KeyBinding> keyBinds = NonNullList.func_191196_a();

    public SimplyBackpacks() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientStuff);
        MinecraftForge.EVENT_BUS.addListener(this::pickupEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
    }

    public void setup(FMLCommonSetupEvent event) {
        network = sbnetwork.register();
    }

    private void pickupEvent(EntityItemPickupEvent event) {
        if (event.getPlayer().field_71070_bA instanceof SBContainer || event.getPlayer().func_70093_af()) {
            return;
        }
        PlayerInventory playerInv = event.getPlayer().field_71071_by;
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = playerInv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemBackpackBase) || !((ItemBackpackBase)stack.func_77973_b()).pickupEvent(event, stack)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    public static ItemStack findBackpack(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemBackpackBase) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemBackpackBase) {
            return player.func_184592_cb();
        }
        PlayerInventory inventory = player.field_71071_by;
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemBackpackBase)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (((KeyBinding)this.keyBinds.get(0)).func_151468_f()) {
            network.sendToServer((Object)new ToggleMessage());
        }
        if (((KeyBinding)this.keyBinds.get(1)).func_151468_f()) {
            network.sendToServer((Object)new OpenMessage());
        }
    }

    private void clientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)SBContainer.type, SBGui::new);
        ScreenManager.func_216911_a((ContainerType)FilterContainer.type, FilterGui::new);
        this.keyBinds.add(0, (Object)new KeyBinding("key.simplybackpacks.backpackpickup.desc", -1, "key.simplybackpacks.category"));
        this.keyBinds.add(1, (Object)new KeyBinding("key.simplybackpacks.backpackopen.desc", -1, "key.simplybackpacks.category"));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(0)));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(1)));
    }

    static {
        sbnetwork = new SBNetwork();
        commonBackpack = new ItemBackpackBase("commonbackpack", 18, Rarity.COMMON);
        uncommonBackpack = new ItemBackpackBase("uncommonbackpack", 33, Rarity.UNCOMMON);
        rareBackpack = new ItemBackpackBase("rarebackpack", 66, Rarity.RARE);
        epicBackpack = new ItemBackpackBase("epicbackpack", 99, Rarity.EPIC);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)commonBackpack.setName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)uncommonBackpack.setName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)rareBackpack.setName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)epicBackpack.setName());
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> containerRegistryEvent) {
            containerRegistryEvent.getRegistry().register((IForgeRegistryEntry)SBContainer.type);
            containerRegistryEvent.getRegistry().register((IForgeRegistryEntry)FilterContainer.type);
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            event.getRegistry().register(new CopyBackpackDataRecipe.Serializer().setRegistryName(new ResourceLocation(SimplyBackpacks.MODID, "backpack_upgrade")));
        }
    }
}

