/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.BackpackItemHandler;
import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.items.ItemBackpackBase;
import com.flanks255.simplybackpacks.network.FilterMessage;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FilterContainer
extends Container {
    public BackpackItemHandler itemHandler;
    private int slotID;
    private PlayerEntity player;
    private ItemStack item;
    public static final ContainerType type = (ContainerType)new ContainerType(FilterContainer::new).setRegistryName("sb_filter_container");

    public boolean func_75145_c(PlayerEntity playerIn) {
        return !playerIn.func_184614_ca().func_190926_b();
    }

    public FilterContainer(int windowId, PlayerInventory playerInventory) {
        this(windowId, playerInventory.field_70458_d.field_70170_p, playerInventory.field_70458_d.func_180425_c(), playerInventory, playerInventory.field_70458_d);
    }

    public FilterContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        super(type, windowId);
        this.item = this.findBackpack(playerEntity);
        if (this.item == null || this.item.func_190926_b()) {
            playerEntity.func_71053_j();
            return;
        }
        IItemHandler tmp = (IItemHandler)this.item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (tmp == null) {
            return;
        }
        if (tmp instanceof BackpackItemHandler) {
            this.itemHandler = (BackpackItemHandler)tmp;
            this.itemHandler.load();
            this.player = playerEntity;
        } else {
            playerEntity.func_71053_j();
        }
        this.addPlayerSlots(playerInventory);
    }

    private ItemStack findBackpack(PlayerEntity playerEntity) {
        PlayerInventory inv = playerEntity.field_71071_by;
        if (playerEntity.func_184614_ca().func_77973_b() instanceof ItemBackpackBase) {
            for (int i = 0; i <= 35; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack != playerEntity.func_184614_ca()) continue;
                this.slotID = i;
                return stack;
            }
        } else if (playerEntity.func_184592_cb().func_77973_b() instanceof ItemBackpackBase) {
            for (int i = 0; i <= 35; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack != playerEntity.func_184592_cb()) continue;
                this.slotID = i;
                return stack;
            }
        } else {
            for (int i = 0; i <= 35; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBackpackBase)) continue;
                this.slotID = i;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity playerIn) {
        if (slotId >= 0 && this.func_75139_a(slotId).func_75211_c() == playerIn.func_184614_ca()) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        if (slotId >= 0) {
            this.func_75139_a((int)slotId).field_75224_c.func_70296_d();
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, playerIn);
    }

    public int getFilterOpts() {
        return this.item.func_196082_o().func_74762_e("Filter-OPT");
    }

    public boolean getPickup() {
        return this.item.func_196082_o().func_74767_n("Pickup");
    }

    public boolean togglePickup() {
        CompoundNBT nbt = this.item.func_196082_o();
        boolean Pickup = !nbt.func_74767_n("Pickup");
        nbt.func_74757_a("Pickup", Pickup);
        if (this.player.func_130014_f_().field_72995_K) {
            SimplyBackpacks.network.sendToServer((Object)new ToggleMessage());
        }
        return Pickup;
    }

    public int setFilterOpts(int newOpts) {
        CompoundNBT nbt = this.item.func_196082_o();
        nbt.func_74768_a("Filter-OPT", newOpts);
        this.item.func_77982_d(nbt);
        if (this.player.func_130014_f_().field_72995_K) {
            SimplyBackpacks.network.sendToServer((Object)new FilterMessage(newOpts));
        }
        return newOpts;
    }

    public void saveFilter(int newOpts) {
        CompoundNBT nbt = this.item.func_196082_o();
        nbt.func_74768_a("Filter-OPT", newOpts);
        this.item.func_77982_d(nbt);
    }

    public void addPlayerSlots(PlayerInventory playerInventory) {
        int originX = 7;
        int originY = 83;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, x + 1, y + 1));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            this.func_75146_a(new Slot((IInventory)playerInventory, col, x + 1, y + 1));
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (playerIn.field_71071_by.func_70445_o().func_190926_b()) {
            this.itemHandler.filter.removeItem(id);
        } else {
            ItemStack fake = playerIn.field_71071_by.func_70445_o().func_77946_l();
            fake.func_190920_e(1);
            this.itemHandler.filter.setItem(id, fake);
        }
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return ItemStack.field_190927_a;
    }
}

