/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.items;

import com.flanks255.simplybackpacks.BackpackItemHandler;
import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.network.ToggleMessageMessage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBackpackBase
extends Item {
    String name;
    Integer size;
    Rarity field_208075_l;

    public ItemBackpackBase(String name, Integer size, Rarity rarity) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.name = name;
        this.size = size;
        this.field_208075_l = rarity;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.field_208075_l;
    }

    public ItemBackpackBase setName() {
        this.setRegistryName("simplybackpacks", this.name);
        return this;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, final PlayerEntity playerIn, final Hand handIn) {
        if (!worldIn.field_72995_K) {
            if (playerIn.func_70093_af()) {
                playerIn.func_213829_a(new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new StringTextComponent("Backpack Filter");
                    }

                    @Nullable
                    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                        return new FilterContainer(p_createMenu_1_, p_createMenu_3_.field_70170_p, p_createMenu_3_.func_180425_c(), p_createMenu_2_, p_createMenu_3_);
                    }
                });
            } else {
                playerIn.func_213829_a(new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return playerIn.func_184586_b(handIn).func_200301_q();
                    }

                    @Nullable
                    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                        return new SBContainer(p_createMenu_1_, p_createMenu_3_.field_70170_p, p_createMenu_3_.func_180425_c(), p_createMenu_2_, p_createMenu_3_);
                    }
                });
            }
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new BackpackCaps(stack, this.size, nbt);
    }

    public void togglePickup(PlayerEntity playerEntity, ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        boolean Pickup = !nbt.func_74767_n("Pickup");
        nbt.func_74757_a("Pickup", Pickup);
        if (playerEntity instanceof ServerPlayerEntity) {
            SimplyBackpacks.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new ToggleMessageMessage(Pickup));
        } else {
            playerEntity.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(Pickup ? "simplybackpacks.autopickupenabled" : "simplybackpacks.autopickupdisabled"), (Object[])new Object[0])), true);
        }
    }

    public boolean filterItem(ItemStack item, ItemStack packItem) {
        IItemHandler tmp = (IItemHandler)packItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (tmp == null || !(tmp instanceof BackpackItemHandler)) {
            return false;
        }
        int filterOpts = packItem.func_196082_o().func_74762_e("Filter-OPT");
        boolean whitelist = (filterOpts & 1) > 0;
        boolean nbtMatch = (filterOpts & 2) > 0;
        BackpackItemHandler handler = (BackpackItemHandler)tmp;
        for (int i = 0; i < 16; ++i) {
            ItemStack fStack = handler.filter.getStackInSlot(i);
            if (fStack.func_190926_b() || !fStack.func_77969_a(item)) continue;
            if (nbtMatch) {
                return ItemStack.func_77970_a((ItemStack)fStack, (ItemStack)item) == whitelist;
            }
            return whitelist;
        }
        return !whitelist;
    }

    public boolean pickupEvent(EntityItemPickupEvent event, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_74767_n("Pickup")) {
            return false;
        }
        LazyOptional stupidIdiot = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!stupidIdiot.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)stupidIdiot.orElse(null);
        if (handler == null) {
            return false;
        }
        if (!this.filterItem(event.getItem().func_92059_d(), stack)) {
            return false;
        }
        ItemStack pickedUp = event.getItem().func_92059_d();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            if (!slot.func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot, (ItemStack)pickedUp) || slot.func_190916_E() >= slot.func_77976_d() || slot.func_190916_E() >= handler.getSlotLimit(i))) continue;
            int remainder = handler.insertItem(i, pickedUp.func_77946_l(), false).func_190916_E();
            pickedUp.func_190920_e(remainder);
            if (remainder == 0) break;
        }
        return pickedUp.func_190926_b();
    }

    private boolean hasTranslation(String key) {
        return !I18n.func_135052_a((String)key, (Object[])new Object[0]).equals(key);
    }

    private String fallbackString(String key, String fallback) {
        String tmp = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        return tmp.equals(key) ? fallback : tmp;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String translationKey = this.func_77658_a();
        boolean pickupEnabled = stack.func_196082_o().func_74767_n("Pickup");
        if (pickupEnabled) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"simplybackpacks.autopickupenabled", (Object[])new Object[0])));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"simplybackpacks.autopickupdisabled", (Object[])new Object[0])));
        }
        if (Screen.hasShiftDown()) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(translationKey + ".info"), (Object[])new Object[0])));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(translationKey + ".info2"), (Object[])new Object[0])));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(translationKey + ".info3"), (Object[])new Object[0])));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(this.fallbackString("simplybackpacks.shift", "Press <\u00c2\u00a76\u00c2\u00a7oShift\u00c2\u00a7r> for info.")));
        }
    }

    class BackpackCaps
    implements ICapabilitySerializable {
        private int size;
        private ItemStack itemStack;
        private BackpackItemHandler inventory;
        private LazyOptional<IItemHandler> optional;

        public BackpackCaps(ItemStack stack, int size, CompoundNBT nbtIn) {
            this.itemStack = stack;
            this.size = size;
            this.inventory = new BackpackItemHandler(this.itemStack, size);
            this.optional = LazyOptional.of(() -> this.inventory);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public INBT serializeNBT() {
            this.inventory.save();
            return new CompoundNBT();
        }

        public void deserializeNBT(INBT nbt) {
            this.inventory.load();
        }
    }
}

