/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackItemHandler
extends ItemStackHandler {
    private ItemStack itemStack;
    private int size;
    private boolean dirty = false;
    private boolean loaded = false;
    public FilterItemHandler filter = new FilterItemHandler();

    public BackpackItemHandler(ItemStack itemStack, int size) {
        super(size);
        this.size = size;
        this.itemStack = itemStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!SimplyBackpacks.filterItem(stack)) {
            return stack;
        }
        this.dirty = true;
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.dirty = true;
        return super.extractItem(slot, amount, simulate);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot)))) {
            this.onContentsChanged(slot);
        }
        this.stacks.set(slot, (Object)stack);
    }

    public void setDirty() {
        this.dirty = true;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.dirty = true;
    }

    public void load() {
        this.load(this.itemStack.func_196082_o());
    }

    public void loadIfNotLoaded() {
        if (!this.loaded) {
            this.load();
        }
        this.loaded = true;
    }

    public void load(@Nonnull CompoundNBT nbt) {
        if (nbt.func_74764_b("Inventory")) {
            this.deserializeNBT(nbt.func_74775_l("Inventory"));
        }
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
    }

    public void save() {
        if (this.dirty) {
            CompoundNBT nbt = this.itemStack.func_196082_o();
            nbt.func_218657_a("Inventory", (INBT)this.serializeNBT());
            nbt.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
            this.dirty = false;
        }
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(this.size);
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        this.onLoad();
    }

    public class FilterItemHandler
    extends ItemStackHandler {
        public FilterItemHandler() {
            super(16);
        }

        public void removeItem(int slot) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
            BackpackItemHandler.this.dirty = true;
            BackpackItemHandler.this.save();
        }

        public void setItem(int slot, ItemStack item) {
            if (!SimplyBackpacks.filterItem(item)) {
                return;
            }
            this.setStackInSlot(slot, item);
            BackpackItemHandler.this.dirty = true;
            BackpackItemHandler.this.save();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!SimplyBackpacks.filterItem(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

