/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.CopyBackpackDataRecipe;
import com.flanks255.simplybackpacks.configuration.CommonConfiguration;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.data.Generator;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.FilterGui;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.gui.SBGui;
import com.flanks255.simplybackpacks.items.ItemBackpackBase;
import com.flanks255.simplybackpacks.network.OpenMessage;
import com.flanks255.simplybackpacks.network.SBNetwork;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simplybackpacks")
public class SimplyBackpacks {
    public static final String MODID = "simplybackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"simplybackpacks");
    public static SimpleChannel NETWORK;
    public static final ITag.INamedTag<Item> HOLDS_ITEMS;
    public static final ITag.INamedTag<Item> STORAGEDRAWERS;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<ContainerType<?>> CONTAINERS;
    private static final DeferredRegister<IRecipeSerializer<?>> RECIPES;
    public static final RegistryObject<IRecipeSerializer<?>> COPYRECIPE;
    public static final RegistryObject<ContainerType<SBContainer>> SBCONTAINER;
    public static final RegistryObject<ContainerType<FilterContainer>> FILTERCONTAINER;
    public static final RegistryObject<Item> COMMONBACKPACK;
    public static final RegistryObject<Item> UNCOMMONBACKPACK;
    public static final RegistryObject<Item> RAREBACKPACK;
    public static final RegistryObject<Item> EPICBACKPACK;
    private final NonNullList<KeyBinding> keyBinds = NonNullList.func_191196_a();

    public SimplyBackpacks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfiguration.COMMON_CONFIG);
        bus.addListener(this::onConfigReload);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Generator::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::pickupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
    }

    public void setup(FMLCommonSetupEvent event) {
        NETWORK = SBNetwork.register();
    }

    private void pickupEvent(EntityItemPickupEvent event) {
        if (event.getPlayer().field_71070_bA instanceof SBContainer || event.getPlayer().func_225608_bj_() || event.getItem().func_92059_d().func_77973_b() instanceof ItemBackpackBase) {
            return;
        }
        PlayerInventory playerInv = event.getPlayer().field_71071_by;
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = playerInv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemBackpackBase) || !((ItemBackpackBase)stack.func_77973_b()).pickupEvent(event, stack)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    public static ItemStack findBackpack(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemBackpackBase) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemBackpackBase) {
            return player.func_184592_cb();
        }
        PlayerInventory inventory = player.field_71071_by;
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemBackpackBase)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (((KeyBinding)this.keyBinds.get(0)).func_151468_f()) {
            NETWORK.sendToServer((Object)new ToggleMessage());
        }
        if (((KeyBinding)this.keyBinds.get(1)).func_151468_f()) {
            NETWORK.sendToServer((Object)new OpenMessage());
        }
    }

    private void clientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SBCONTAINER.get()), SBGui::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)FILTERCONTAINER.get()), FilterGui::new);
        this.keyBinds.add(0, (Object)new KeyBinding("key.simplybackpacks.backpackpickup.desc", -1, "key.simplybackpacks.category"));
        this.keyBinds.add(1, (Object)new KeyBinding("key.simplybackpacks.backpackopen.desc", -1, "key.simplybackpacks.category"));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(0)));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(1)));
    }

    private void onConfigReload(ModConfig.ModConfigEvent event) {
        ConfigCache.RefreshCache();
    }

    public static boolean filterItem(ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_77973_b() instanceof ItemBackpackBase) {
            return false;
        }
        if (ConfigCache.WHITELIST.contains(stack.func_77973_b().getRegistryName())) {
            return true;
        }
        if (stack.func_77942_o() && ((tag = stack.func_77978_p()).func_74764_b("Items") || tag.func_74764_b("Inventory"))) {
            return false;
        }
        if (stack.func_77973_b().func_206844_a(HOLDS_ITEMS) || stack.func_77973_b().func_206844_a(STORAGEDRAWERS)) {
            return false;
        }
        return !ConfigCache.BLACKLIST.contains(stack.func_77973_b().getRegistryName());
    }

    static {
        HOLDS_ITEMS = ItemTags.func_199901_a((String)new ResourceLocation("forge", "holds_items").toString());
        STORAGEDRAWERS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("storagedrawers", "drawers"));
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)MODID);
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        COPYRECIPE = RECIPES.register("backpack_upgrade", CopyBackpackDataRecipe.Serializer::new);
        SBCONTAINER = CONTAINERS.register("sb_container", () -> IForgeContainerType.create(SBContainer::new));
        FILTERCONTAINER = CONTAINERS.register("filter_container", () -> IForgeContainerType.create(FilterContainer::new));
        COMMONBACKPACK = ITEMS.register("commonbackpack", () -> new ItemBackpackBase("commonbackpack", 18, Rarity.COMMON));
        UNCOMMONBACKPACK = ITEMS.register("uncommonbackpack", () -> new ItemBackpackBase("uncommonbackpack", 33, Rarity.UNCOMMON));
        RAREBACKPACK = ITEMS.register("rarebackpack", () -> new ItemBackpackBase("rarebackpack", 66, Rarity.RARE));
        EPICBACKPACK = ITEMS.register("epicbackpack", () -> new ItemBackpackBase("epicbackpack", 99, Rarity.EPIC));
    }
}

