/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.block;

import elucent.simplytea.SimplyTea;
import elucent.simplytea.block.BlockTeaTrunk;
import elucent.simplytea.block.IItemBlock;
import elucent.simplytea.core.IModeledObject;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockTeaSapling
extends BlockBush
implements IGrowable,
IModeledObject,
IItemBlock {
    public Item itemBlock = null;
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);

    public BlockTeaSapling(String name, boolean addToTab) {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c(name);
        this.setRegistryName(new ResourceLocation("simplytea", name));
        if (addToTab) {
            this.func_149647_a(SimplyTea.tab);
        }
        this.func_149675_a(true);
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_149698_L() {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            BlockTeaSapling.generateTree(worldIn, pos, state, rand);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public static void generateTree(World world, BlockPos pos, IBlockState state, Random random) {
        IBlockState trunk = SimplyTea.tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false));
        world.func_175656_a(pos, trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.STUMP)));
        world.func_175656_a(pos.func_177984_a(), trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.BOTTOM)));
        int height = 3;
        if (world.func_175623_d(pos.func_177981_b(4))) {
            height += random.nextInt(world.func_175623_d(pos.func_177981_b(5)) ? 3 : 2);
        }
        for (int i = 2; i < height; ++i) {
            boolean north = random.nextBoolean();
            boolean south = random.nextBoolean();
            boolean west = random.nextBoolean();
            boolean east = random.nextBoolean();
            BlockPos branch = pos.func_177981_b(i);
            if (north) {
                BlockTeaSapling.setBlockSafe(world, branch.func_177978_c(), trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.SOUTH)));
            }
            if (east) {
                BlockTeaSapling.setBlockSafe(world, branch.func_177974_f(), trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.WEST)));
            }
            if (south) {
                BlockTeaSapling.setBlockSafe(world, branch.func_177968_d(), trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.NORTH)));
            }
            if (west) {
                BlockTeaSapling.setBlockSafe(world, branch.func_177976_e(), trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.EAST)));
            }
            world.func_175656_a(branch, trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.MIDDLE)));
        }
        world.func_175656_a(pos.func_177981_b(height), trunk.func_177226_a(BlockTeaTrunk.TYPE, (Comparable)((Object)BlockTeaTrunk.TrunkType.TOP)));
    }

    private static void setBlockSafe(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            world.func_175656_a(pos, state);
        }
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        for (int i = 1; i <= 3; ++i) {
            if (world.func_175623_d(pos.func_177981_b(i))) continue;
            return false;
        }
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }
}

