/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.core;

import net.minecraftforge.common.config.Config;

@net.minecraftforge.common.config.Config(modid="simplytea")
public class Config {
    @Config.Comment(value={"If true, filling a teapot consumes the water source block. Useful for packs with finite water."})
    @Config.LangKey(value="simplytea.config.teapot_consume_source")
    public static boolean teapot_consume_source = false;
    @Config.Comment(value={"Hunger restored from tea"})
    @Config.LangKey(value="simplytea.config.tea")
    public static TeaCategory tea = new TeaCategory();
    @Config.Comment(value={"Options related to the tea tree"})
    @Config.LangKey(value="simplytea.config.tree")
    public static TreeCategory tree = new TreeCategory();

    public static class Cocoa {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger = 4;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation = 0.6;
        @Config.Comment(value={"If true, drinking cocoa clears status effects like milk"})
        @Config.LangKey(value="simplytea.config.tea.cocoa.clear_effects")
        public boolean clear_effects = true;
    }

    public static class HerbalTea {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hearts restored when sleeping after drinking this tea."})
        @Config.RangeInt(min=0, max=10)
        @Config.LangKey(value="simplytea.config.tea.herbal.hearts")
        public int hearts;

        private HerbalTea(int defaultHunger, double defaultSaturation, int hearts) {
            this.hunger = defaultHunger;
            this.saturation = defaultSaturation;
            this.hearts = hearts;
        }
    }

    public static class CaffeineTea {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Time in seconds for the caffeinated effect from drinking this tea."})
        @Config.RangeInt(min=0, max=600)
        @Config.LangKey(value="simplytea.config.tea.caffeinated_time")
        public int caffeinated_time;

        private CaffeineTea(int defaultHunger, double defaultSaturation, int caffeinatedTime) {
            this.hunger = defaultHunger;
            this.saturation = defaultSaturation;
            this.caffeinated_time = caffeinatedTime;
        }
    }

    public static class TreeCategory {
        @Config.RequiresMcRestart
        @Config.Comment(value={"If true, generates tea trees in forest biomes."})
        @Config.LangKey(value="simplytea.config.tree.enable_generation")
        public boolean enable_generation = true;
        @Config.Comment(value={"Percent chance of leaves to regrow every random tick. Set to 1 to regrow every random tick (old behavior)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="simplytea.config.tree.leaf_growth_chance")
        public double leaf_growth_chance = 0.05;
        @Config.Comment(value={"Maximum number of leaves dropped when a single branch is broken or sheared."})
        @Config.RangeInt(min=1, max=64)
        @Config.LangKey(value="simplytea.config.tree.max_leaves")
        public int max_leaves = 3;
        @Config.Comment(value={"Maximum number of sticks dropped when a single branch is broken or sheared."})
        @Config.RangeInt(min=1, max=64)
        @Config.LangKey(value="simplytea.config.tree.max_leaves")
        public int max_sticks = 3;
        @Config.Comment(value={"Percent chance for a tree to drop a sapling when broken or sheared"})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="simplytea.config.tree.sapling_chance")
        public double sapling_chance = 0.1;
    }

    public static class TeaCategory {
        @Config.Comment(value={"Stats for floral tea."})
        @Config.LangKey(value="simplytea.config.tea.floral")
        public HerbalTea floral = new HerbalTea(2, 0.5, 1);
        @Config.Comment(value={"Stats for green tea."})
        @Config.LangKey(value="simplytea.config.tea.green")
        public CaffeineTea green = new CaffeineTea(3, 0.5, 150);
        @Config.Comment(value={"Stats for black tea."})
        @Config.LangKey(value="simplytea.config.tea.black")
        public CaffeineTea black = new CaffeineTea(4, 0.8, 210);
        @Config.Comment(value={"Stats for chai tea."})
        @Config.LangKey(value="simplytea.config.tea.green")
        public CaffeineTea chai = new CaffeineTea(5, 0.6, 150);
        @Config.Comment(value={"Stats and effects for chamomile tea, added when Rustic is loaded."})
        @Config.LangKey(value="simplytea.config.tea.chamomile")
        public HerbalTea chamomile = new HerbalTea(2, 0.5, 2);
        @Config.Comment(value={"Stats and effects for cocoa."})
        @Config.LangKey(value="simplytea.config.tea.cocoa")
        public Cocoa cocoa = new Cocoa();
    }
}

