/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.core.config.Drink;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TeaDrink
extends Drink {
    private TeaEffect type;
    private ForgeConfigSpec.IntValue configurable;
    private int constant;
    private List<Pair<EffectInstance, Float>> effects = null;

    public TeaDrink(String name, ForgeConfigSpec.Builder builder, TeaEffect type, int hunger, double saturation, int time, int level) {
        super(name, builder, hunger, saturation);
        this.type = type;
        if (type.isLevel()) {
            this.configurable = builder.comment(new String[]{String.format("Level of the %s effect when drinking this tea.", new Object[]{type}), "Set to 0 to disable the effect."}).translation("simplytea.config.tea.level").defineInRange("level", level, 0, 10);
            this.constant = time;
        } else {
            this.configurable = builder.comment(new String[]{String.format("Time in seconds for the %s effect from drinking this tea.", new Object[]{type}), "Set to 0 to disable the effect."}).translation("simplytea.config.tea.time").defineInRange("time", time, 0, 600);
            this.constant = level;
        }
        builder.pop();
    }

    @Nullable
    private EffectInstance getEffect() {
        int configurable = (Integer)this.configurable.get();
        if (configurable != 0) {
            switch (this.type) {
                case CAFFEINE: {
                    return new EffectInstance(Registration.caffeinated, configurable * 20, this.constant - 1);
                }
                case HERBAL: {
                    return new EffectInstance(Registration.restful, this.constant * 20, configurable - 1);
                }
                case ENDERFALLING: {
                    return new EffectInstance(Registration.enderfalling, configurable * 20, this.constant - 1);
                }
            }
        }
        return null;
    }

    public List<Pair<EffectInstance, Float>> func_221464_f() {
        if (this.effects != null) {
            return this.effects;
        }
        this.effects = new ArrayList<Pair<EffectInstance, Float>>();
        EffectInstance effect = this.getEffect();
        if (effect != null) {
            this.effects.add((Pair<EffectInstance, Float>)Pair.of((Object)effect, (Object)Float.valueOf(1.0f)));
        }
        return this.effects;
    }

    public void invalidEffects() {
        this.effects = null;
    }

    public static enum TeaEffect {
        CAFFEINE(false),
        HERBAL(true),
        ENDERFALLING(false);

        private boolean level;

        private TeaEffect(boolean level) {
            this.level = level;
        }

        public boolean isLevel() {
            return this.level;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

