/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.core;

import knightminer.simplytea.core.config.CocoaDrink;
import knightminer.simplytea.core.config.TeaDrink;
import knightminer.simplytea.core.config.Teapot;
import knightminer.simplytea.core.config.Tree;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="simplytea", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.SERVER.floral_tea.invalidEffects();
            Config.SERVER.green_tea.invalidEffects();
            Config.SERVER.black_tea.invalidEffects();
            Config.SERVER.chai_tea.invalidEffects();
            Config.SERVER.chorus_tea.invalidEffects();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public TeaDrink black_tea;
        public TeaDrink green_tea;
        public TeaDrink floral_tea;
        public TeaDrink chai_tea;
        public TeaDrink chorus_tea;
        public CocoaDrink cocoa;
        public Teapot teapot;
        public Tree tree;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Stats for each available drink type").push("drinks");
            this.floral_tea = new TeaDrink("floral", builder, TeaDrink.TeaEffect.HERBAL, 2, 0.5, 20, 2);
            this.green_tea = new TeaDrink("green", builder, TeaDrink.TeaEffect.CAFFEINE, 3, 0.5, 150, 2);
            this.black_tea = new TeaDrink("black", builder, TeaDrink.TeaEffect.CAFFEINE, 4, 0.8, 210, 2);
            this.chai_tea = new TeaDrink("chai", builder, TeaDrink.TeaEffect.CAFFEINE, 5, 0.6, 150, 3);
            this.chorus_tea = new TeaDrink("chorus", builder, TeaDrink.TeaEffect.ENDERFALLING, 3, 0.9, 150, 1);
            this.cocoa = new CocoaDrink(builder, 4, 0.6);
            builder.pop();
            this.teapot = new Teapot(builder);
            this.tree = new Tree(builder);
        }
    }
}

