/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIcon
extends Pane {
    private static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    private static final float GUI_ITEM_Z_TRANSLATE = 32.0f;
    private ItemStack itemStack;

    public ItemIcon() {
    }

    public ItemIcon(PaneParams params) {
        super(params);
        Item item;
        String itemName = params.getStringAttribute("item", null);
        if (itemName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))) != null) {
            this.itemStack = new ItemStack((IItemProvider)item, 1);
        }
    }

    public void setItem(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    @Override
    public void drawSelf(int mx, int my) {
        if (this.itemStack != null) {
            RenderSystem.pushMatrix();
            RenderHelper.func_74518_a();
            this.drawItemStack(this.itemStack, this.x, this.y);
            RenderSystem.popMatrix();
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        if (stack.func_190926_b()) {
            return;
        }
        ItemRenderer itemRenderer = this.mc.func_175599_af();
        RenderSystem.translatef((float)x, (float)y, (float)32.0f);
        RenderSystem.scalef((float)((float)this.getWidth() / 16.0f), (float)((float)this.getHeight() / 16.0f), (float)1.0f);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.mc.field_71466_p;
        }
        itemRenderer.func_180450_b(stack, 0, 0);
        itemRenderer.func_180453_a(font, stack, 0, 0, null);
    }

    @Override
    public void drawSelfLast(int mx, int my) {
        if (this.itemStack == null || this.itemStack.func_190926_b() || !this.isHovered) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderHelper.func_74518_a();
        RenderSystem.translatef((float)mx, (float)my, (float)32.0f);
        RenderSystem.scalef((float)((float)this.getWidth() / 16.0f), (float)((float)this.getHeight() / 16.0f), (float)1.0f);
        FontRenderer font = this.itemStack.func_77973_b().getFontRenderer(this.itemStack);
        if (font == null) {
            font = this.mc.field_71466_p;
        }
        GuiUtils.preItemToolTip((ItemStack)this.itemStack);
        this.mc.field_71462_r.renderTooltip(this.mc.field_71462_r.getTooltipFromItem(this.itemStack), 0, 0, font);
        GuiUtils.postItemToolTip();
        RenderSystem.popMatrix();
    }
}

