/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ButtonVanilla;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.OverlayView;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DropDownList
extends View
implements ButtonHandler {
    protected OverlayView overlay;
    protected Button button;
    protected ScrollingList list;
    protected DataProvider dataProvider;
    protected Consumer<DropDownList> handler;
    protected int dropDownWidth;
    protected int dropDownHeight;
    protected int selectedIndex = -1;
    protected int dropDownFixX = 0;

    public DropDownList() {
    }

    public DropDownList(PaneParams params) {
        super(params);
        PaneParams.SizePair dropDownSize = params.getSizePairAttribute("dropDownSize", null, null);
        this.dropDownWidth = dropDownSize == null ? this.width : dropDownSize.getX();
        this.dropDownHeight = dropDownSize == null ? this.width : dropDownSize.getY();
        this.dropDownFixX = params.getIntAttribute("dropfixx", this.dropDownFixX);
        this.button = params.getStringAttribute("source", "").isEmpty() ? new ButtonVanilla(params) : new ButtonImage(params);
        this.button.putInside(this);
        this.overlay = new OverlayView();
        this.overlay.setVisible(false);
        this.overlay.setPosition(0, 0);
        this.list = new ScrollingList(params);
        if (params.getIntAttribute("maxContentHeight") != 0) {
            this.list.setMaxHeight(params.getIntAttribute("maxContentHeight"));
        }
        this.list.setSize(this.dropDownWidth, this.dropDownHeight);
        this.list.setPosition(this.x + this.width / 2 - this.dropDownWidth / 2 + this.dropDownFixX, this.y + this.height);
        this.list.putInside(this.overlay);
        this.list.parseChildren(params);
        this.button.setHandler(this);
    }

    @Override
    public void onButtonClicked(@NotNull Button buttonIn) {
        if (buttonIn == this.button) {
            if (this.overlay.isVisible()) {
                this.close();
            } else {
                this.overlay.setSize(this.getWindow().getInteriorWidth(), this.getWindow().getInteriorHeight());
                this.overlay.putInside(buttonIn.getWindow());
                this.open();
            }
        } else {
            this.onButtonClickedFromList(buttonIn);
        }
    }

    public void close() {
        this.overlay.setVisible(false);
    }

    public void open() {
        this.refreshElementPanes();
        this.overlay.setVisible(true);
        this.overlay.setFocus();
    }

    private void onButtonClickedFromList(@NotNull Button buttonIn) {
        Label idLabel = buttonIn.getParent().findPaneOfTypeByID("id", Label.class);
        if (idLabel != null) {
            int index = Integer.parseInt(idLabel.getLabelText());
            this.setSelectedIndex(index);
            this.close();
        }
    }

    public void refreshElementPanes() {
        this.list.refreshElementPanes();
        if (this.list.getContentHeight() < this.dropDownHeight) {
            this.list.setSize(this.dropDownWidth, this.list.getContentHeight());
        } else {
            this.list.setSize(this.dropDownWidth, this.dropDownHeight);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.dataProvider.getElementCount()) {
            return;
        }
        this.selectedIndex = index;
        this.button.setLabel(this.dataProvider.getLabel(this.selectedIndex));
        if (this.handler != null) {
            this.handler.accept(this);
        }
    }

    public void selectPrevious() {
        if (this.dataProvider.getElementCount() == 0) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex((this.selectedIndex + this.dataProvider.getElementCount() - 1) % this.dataProvider.getElementCount());
        }
    }

    public void selectNext() {
        if (this.dataProvider.getElementCount() == 0) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex((this.selectedIndex + 1) % this.dataProvider.getElementCount());
        }
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.list.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return DropDownList.this.dataProvider.getElementCount();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                DropDownList.this.updateDropDownItem(rowPane, index, DropDownList.this.dataProvider.getLabel(index));
            }
        });
        this.refreshElementPanes();
    }

    private void updateDropDownItem(@NotNull Pane rowPane, int index, String label) {
        Button choiceButton = rowPane.findPaneOfTypeByID("button", Button.class);
        if (choiceButton != null) {
            Label idLabel = rowPane.findPaneOfTypeByID("id", Label.class);
            if (idLabel != null) {
                idLabel.setLabelText(Integer.toString(index));
            }
            choiceButton.setLabel(label);
            choiceButton.setHandler(this);
        }
    }

    @Override
    public void setVisible(boolean v) {
        this.button.setVisible(v);
    }

    @Override
    public void setEnabled(boolean e) {
        this.button.setEnabled(e);
    }

    @Override
    public void drawSelf(int mx, int my) {
        this.button.drawSelf(mx, my);
    }

    @Override
    public void drawSelfLast(int mx, int my) {
        this.button.drawSelfLast(mx, my);
    }

    @Override
    public boolean click(double mx, double my) {
        return this.button.click(mx, my);
    }

    public void setHandler(Consumer<DropDownList> h) {
        this.handler = h;
    }

    @Override
    public boolean isPointInPane(double mx, double my) {
        return super.isPointInPane(mx, my) || this.overlay.isVisible() && this.list.isPointInPane(mx, my);
    }

    public static interface DataProvider {
        public int getElementCount();

        public String getLabel(int var1);
    }
}

