/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Blueprint {
    private static final String ENTITY_POS = "Pos";
    private final List<String> requiredMods;
    private short sizeX;
    private short sizeY;
    private short sizeZ;
    private short palleteSize;
    private List<BlockState> palette;
    private String name;
    private String[] architects;
    private String[] missingMods;
    private short[][][] structure;
    private CompoundNBT[][][] tileEntities;
    private CompoundNBT[] entities = new CompoundNBT[0];
    private List<BlockInfo> cacheBlockInfo = null;
    private Map<BlockPos, BlockInfo> cacheBlockInfoMap = null;
    private Map<BlockPos, CompoundNBT[]> cacheEntitiesMap = null;
    private BlockPos cachePrimaryOffset = null;

    protected Blueprint(short sizeX, short sizeY, short sizeZ, short palleteSize, List<BlockState> pallete, short[][][] structure, CompoundNBT[] tileEntities, List<String> requiredMods) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.palleteSize = palleteSize;
        this.palette = pallete;
        this.structure = structure;
        this.tileEntities = new CompoundNBT[sizeY][sizeZ][sizeX];
        for (CompoundNBT te : tileEntities) {
            if (te == null) continue;
            this.tileEntities[te.func_74765_d((String)"y")][te.func_74765_d((String)"z")][te.func_74765_d((String)"x")] = te;
        }
        this.requiredMods = requiredMods;
    }

    public Blueprint(short sizeX, short sizeY, short sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.structure = new short[sizeY][sizeZ][sizeX];
        this.tileEntities = new CompoundNBT[sizeY][sizeZ][sizeX];
        this.requiredMods = new ArrayList<String>();
        this.palette = new ArrayList<BlockState>();
        this.palette.add(0, ModBlocks.blockSubstitution.func_176223_P());
    }

    public short getSizeX() {
        return this.sizeX;
    }

    public short getSizeY() {
        return this.sizeY;
    }

    public short getSizeZ() {
        return this.sizeZ;
    }

    public short getPalleteSize() {
        return this.palleteSize;
    }

    public BlockState[] getPalette() {
        return this.palette.toArray(new BlockState[0]);
    }

    public void addBlockState(BlockPos pos, BlockState state) {
        int index = -1;
        for (int i = 0; i < this.palette.size(); ++i) {
            if (!this.palette.get(i).equals(state)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = this.palleteSize + 1;
            this.palleteSize = (short)(this.palleteSize + 1);
            this.palette.add(state);
        }
        this.structure[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()] = (short)index;
        this.cacheReset(true);
    }

    public short[][][] getStructure() {
        return this.structure;
    }

    public CompoundNBT[][][] getTileEntities() {
        return this.tileEntities;
    }

    public CompoundNBT[] getEntities() {
        return this.entities;
    }

    public void setEntities(CompoundNBT[] entities) {
        this.entities = entities;
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    public String getName() {
        return this.name;
    }

    public Blueprint setName(String name) {
        this.name = name;
        return this;
    }

    public String[] getArchitects() {
        return this.architects;
    }

    public void setArchitects(String[] architects) {
        this.architects = architects;
    }

    public String[] getMissingMods() {
        return this.missingMods;
    }

    public Blueprint setMissingMods(String ... missingMods) {
        this.missingMods = missingMods;
        return this;
    }

    public final List<CompoundNBT> getEntitiesAsList() {
        return Arrays.stream(this.entities).collect(Collectors.toList());
    }

    public final List<BlockInfo> getBlockInfoAsList() {
        if (this.cacheBlockInfo == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheBlockInfo;
    }

    public final Map<BlockPos, BlockInfo> getBlockInfoAsMap() {
        if (this.cacheBlockInfoMap == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheBlockInfoMap;
    }

    public final Map<BlockPos, CompoundNBT[]> getCachedEntitiesAsMap() {
        if (this.cacheEntitiesMap == null) {
            this.buildBlockInfoCaches();
        }
        return this.cacheEntitiesMap;
    }

    @Nullable
    public CompoundNBT getTileEntityData(@NotNull BlockPos worldPos, BlockPos structurePos) {
        if (!this.getBlockInfoAsMap().containsKey(structurePos) || !this.getBlockInfoAsMap().get(structurePos).hasTileEntityData()) {
            return null;
        }
        CompoundNBT te = this.getBlockInfoAsMap().get(structurePos).getTileEntityData().func_74737_b();
        BlockPos tePos = structurePos.func_177971_a((Vec3i)worldPos);
        te.func_74768_a("x", tePos.func_177958_n());
        te.func_74768_a("y", tePos.func_177956_o());
        te.func_74768_a("z", tePos.func_177952_p());
        return te;
    }

    @Nullable
    public Item getItem(BlockPos pos) {
        BlockInfo info = this.getBlockInfoAsMap().getOrDefault(pos, null);
        if (info == null || info.getState() == null || info.getState().func_177230_c() instanceof AirBlock || info.getState().func_185904_a().func_76224_d()) {
            return null;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(info.getState());
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack.func_77973_b();
        }
        return null;
    }

    private void buildBlockInfoCaches() {
        this.cacheBlockInfo = new ArrayList<BlockInfo>(this.getVolume());
        this.cacheBlockInfoMap = new HashMap<BlockPos, BlockInfo>(this.getVolume());
        this.cacheEntitiesMap = new HashMap<BlockPos, CompoundNBT[]>();
        for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
                    BlockPos tempPos = new BlockPos((int)x, (int)y, (int)z);
                    BlockInfo blockInfo = new BlockInfo(tempPos, this.palette.get(this.structure[y][z][x] & 0xFFFF), this.tileEntities[y][z][x]);
                    this.cacheBlockInfo.add(blockInfo);
                    this.cacheBlockInfoMap.put(tempPos, blockInfo);
                    this.cacheEntitiesMap.put(tempPos, (CompoundNBT[])Arrays.stream(this.getEntities()).filter(data -> data != null && this.isAtPos((CompoundNBT)data, tempPos)).toArray(CompoundNBT[]::new));
                }
            }
        }
    }

    public void setCachePrimaryOffset(BlockPos cachePrimaryOffset) {
        this.cachePrimaryOffset = cachePrimaryOffset;
    }

    public final BlockPos getPrimaryBlockOffset() {
        if (this.cachePrimaryOffset == null) {
            this.cachePrimaryOffset = this.findPrimaryBlockOffset();
        }
        return this.cachePrimaryOffset;
    }

    private BlockPos findPrimaryBlockOffset() {
        List list = this.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.getState().func_177230_c() instanceof IAnchorBlock).collect(Collectors.toList());
        if (list.size() != 1) {
            return new BlockPos(this.getSizeX() / 2, 0, this.getSizeZ() / 2);
        }
        return ((BlockInfo)list.get(0)).getPos();
    }

    private void cacheReset(boolean resetPrimaryOffset) {
        this.cacheBlockInfo = null;
        if (resetPrimaryOffset) {
            this.cachePrimaryOffset = null;
        }
        this.cacheBlockInfoMap = null;
        this.cacheEntitiesMap = null;
    }

    public void rotateWithMirror(Rotation rotation, Mirror mirror, World world) {
        BlockPos primaryOffset = this.getPrimaryBlockOffset();
        BlockPos resultSize = Blueprint.transformedSize(new BlockPos((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ), rotation);
        short newSizeX = (short)resultSize.func_177958_n();
        short newSizeY = (short)resultSize.func_177956_o();
        short newSizeZ = (short)resultSize.func_177952_p();
        short[][][] newStructure = new short[newSizeY][newSizeZ][newSizeX];
        CompoundNBT[] newEntities = new CompoundNBT[this.entities.length];
        CompoundNBT[][][] newTileEntities = new CompoundNBT[newSizeY][newSizeZ][newSizeX];
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        for (int i = 0; i < this.palette.size(); ++i) {
            palette.add(i, this.palette.get(i).func_185902_a(mirror).func_185907_a(rotation));
        }
        BlockPos extremes = Blueprint.transformedBlockPos(this.sizeX, this.sizeY, this.sizeZ, mirror, rotation);
        int minX = extremes.func_177958_n() < 0 ? -extremes.func_177958_n() - 1 : 0;
        int minY = extremes.func_177956_o() < 0 ? -extremes.func_177956_o() - 1 : 0;
        int minZ = extremes.func_177952_p() < 0 ? -extremes.func_177952_p() - 1 : 0;
        this.palette = palette;
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    BlockPos tempPos = Blueprint.transformedBlockPos(x, y, z, mirror, rotation).func_177982_a(minX, minY, minZ);
                    short value = this.structure[y][z][x];
                    BlockState state = (BlockState)palette.get(value & 0xFFFF);
                    if (state.func_177230_c() == Blocks.field_189881_dj) continue;
                    newStructure[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = value;
                    CompoundNBT compound = this.tileEntities[y][z][x];
                    if (compound != null) {
                        compound.func_74768_a("x", tempPos.func_177958_n());
                        compound.func_74768_a("y", tempPos.func_177956_o());
                        compound.func_74768_a("z", tempPos.func_177952_p());
                        if (compound.func_74764_b("blueprintDataProvider")) {
                            CompoundNBT dataCompound = compound.func_74775_l("blueprintDataProvider");
                            Map<BlockPos, List<String>> tagPosMap = IBlueprintDataProvider.readTagPosMapFrom(dataCompound);
                            HashMap<BlockPos, List<String>> newTagPosMap = new HashMap<BlockPos, List<String>>();
                            for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
                                BlockPos newPos = Blueprint.transformedBlockPos(entry.getKey().func_177958_n(), entry.getKey().func_177956_o(), entry.getKey().func_177952_p(), mirror, rotation);
                                newTagPosMap.put(newPos, entry.getValue());
                            }
                            IBlueprintDataProvider.writeMapToCompound(dataCompound, newTagPosMap);
                            BlockPos corner1 = BlockPosUtil.readFromNBT(dataCompound, "corner1");
                            BlockPos corner2 = BlockPosUtil.readFromNBT(dataCompound, "corner2");
                            corner1 = Blueprint.transformedBlockPos(corner1.func_177958_n(), corner1.func_177956_o(), corner1.func_177952_p(), mirror, rotation);
                            corner2 = Blueprint.transformedBlockPos(corner2.func_177958_n(), corner2.func_177956_o(), corner2.func_177952_p(), mirror, rotation);
                            BlockPosUtil.writeToNBT(dataCompound, "corner1", corner1);
                            BlockPosUtil.writeToNBT(dataCompound, "corner2", corner2);
                        }
                    }
                    newTileEntities[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = compound;
                }
            }
        }
        for (int i = 0; i < this.entities.length; ++i) {
            CompoundNBT entitiesCompound = this.entities[i];
            if (entitiesCompound == null) continue;
            newEntities[i] = this.transformEntityInfoWithSettings(entitiesCompound, world, new BlockPos(minX, minY, minZ), rotation, mirror);
        }
        BlockPos newOffsetPos = Template.func_207669_a((BlockPos)primaryOffset, (Mirror)mirror, (Rotation)rotation, (BlockPos)new BlockPos(0, 0, 0));
        this.setCachePrimaryOffset(newOffsetPos.func_177982_a(minX, minY, minZ));
        this.sizeX = newSizeX;
        this.sizeY = newSizeY;
        this.sizeZ = newSizeZ;
        this.structure = newStructure;
        this.entities = newEntities;
        this.tileEntities = newTileEntities;
        this.cacheReset(false);
    }

    public static BlockPos transformedSize(BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
        }
        return pos;
    }

    public static BlockPos transformedBlockPos(int xIn, int y, int zIn, Mirror mirror, Rotation rotation) {
        int x = xIn;
        int z = zIn;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -zIn;
                break;
            }
            case FRONT_BACK: {
                x = -xIn;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return flag ? new BlockPos(x, y, z) : new BlockPos(xIn, y, zIn);
    }

    private CompoundNBT transformEntityInfoWithSettings(CompoundNBT entityInfo, World world, BlockPos pos, Rotation rotation, Mirror mirror) {
        Entity finalEntity;
        Optional type = EntityType.func_220347_a((CompoundNBT)entityInfo);
        if (type.isPresent() && (finalEntity = ((EntityType)type.get()).func_200721_a(world)) != null) {
            finalEntity.deserializeNBT(entityInfo);
            Vec3d entityVec = Blueprint.transformedVec3d(rotation, mirror, finalEntity.func_174791_d()).func_178787_e(new Vec3d((Vec3i)pos));
            finalEntity.field_70126_B = (float)((double)finalEntity.func_184217_a(mirror) - 90.0);
            double rotationYaw = (double)finalEntity.func_184217_a(mirror) + ((double)finalEntity.func_184217_a(mirror) - (double)finalEntity.func_184229_a(rotation));
            if (finalEntity instanceof HangingEntity) {
                finalEntity.func_70107_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c);
            } else {
                finalEntity.func_70012_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c, (float)rotationYaw, finalEntity.field_70125_A);
            }
            return finalEntity.serializeNBT();
        }
        return null;
    }

    private static Vec3d transformedVec3d(Rotation rotation, Mirror mirror, Vec3d vec) {
        double xCoord = vec.field_72450_a;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, vec.field_72448_b, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, vec.field_72448_b, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, vec.field_72448_b, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, vec.field_72448_b, zCoord) : vec;
    }

    private int getVolume() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.palleteSize;
        result = 31 * result + this.getVolume();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        return this.name.equals(other.name) && this.palleteSize == other.palleteSize && this.getVolume() == other.getVolume();
    }

    public BlueprintPositionInfo getBluePrintPositionInfo(BlockPos pos, boolean includeEntities) {
        return new BlueprintPositionInfo(pos, this.getBlockInfoAsMap().get(pos), includeEntities ? this.getCachedEntitiesAsMap().getOrDefault(pos, new CompoundNBT[0]) : new CompoundNBT[]{});
    }

    private boolean isAtPos(@NotNull CompoundNBT entityData, BlockPos pos) {
        ListNBT list = entityData.func_150295_c(ENTITY_POS, 6);
        int x = (int)list.func_150309_d(0);
        int y = (int)list.func_150309_d(1);
        int z = (int)list.func_150309_d(2);
        return new BlockPos(x, y, z).equals((Object)pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockInfoAsMap().get(pos).getState();
    }
}

