/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.event.ClientEventSubscriber;
import com.ldtteam.structurize.network.messages.AddRemoveTagMessage;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WindowTagTool
extends AbstractWindowSkeleton {
    private static final String WINDOW_TAG_TOOL = ":gui/windowtagtool.xml";
    private static final String INPUT_FIELD = "currentTag";
    private static final String LIST_LABEL = "taglistname";
    private static final String LIST_TAG_POS = "tagposlist";
    private static final String LIST_BLOCK = "posblock";
    private static final String TAG_TEXT = "tagnames";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_CLOSE = "closeUI";
    private static final String BUTTON_LIST_REMOVE = "removeTag";
    private String currentTag = "";
    private World world;
    private BlockPos anchorPos = null;
    private ItemStack stack;
    private ScrollingList tagList;
    private List<BlockPos> positionsList;

    public WindowTagTool(String currentTag, BlockPos anchorPos, World world, ItemStack stack) {
        super("structurize:gui/windowtagtool.xml");
        this.world = world;
        this.currentTag = currentTag;
        this.anchorPos = anchorPos;
        this.stack = stack;
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.findPaneOfTypeByID(INPUT_FIELD, TextField.class).setText(this.currentTag);
        this.findPaneOfTypeByID(LIST_LABEL, Label.class).setLabelText("Existing tags in schematic:");
        this.tagList = this.findPaneOfTypeByID(LIST_TAG_POS, ScrollingList.class);
        this.registerButton(BUTTON_CANCEL, this::onCancel);
        this.registerButton(BUTTON_CLOSE, this::onCancel);
        this.registerButton(BUTTON_LIST_REMOVE, this::removeTag);
        this.updateResourceList();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        this.currentTag = this.findPaneOfTypeByID(INPUT_FIELD, TextField.class).getText();
        this.stack.func_196082_o().func_74778_a("currenttag", this.currentTag);
        return result;
    }

    private void removeTag(Button button) {
        int row = this.tagList.getListElementIndexByPane(button);
        BlockPos toRemove = this.positionsList.get(row);
        TileEntity te = this.world.func_175625_s(this.anchorPos);
        if (te instanceof IBlueprintDataProvider) {
            IBlueprintDataProvider dataTE = (IBlueprintDataProvider)te;
            Map<BlockPos, List<String>> map = dataTE.getPositionedTags();
            if (map.containsKey(toRemove) && map.get(toRemove).size() > 0) {
                String tag = map.get(toRemove).get(map.get(toRemove).size() - 1);
                dataTE.removeTag(toRemove, tag);
                Network.getNetwork().sendToServer(new AddRemoveTagMessage(false, tag, toRemove, this.anchorPos));
                ClientEventSubscriber.tagPosList = null;
            }
            this.updateResourceList();
        } else {
            this.close();
        }
    }

    private void onCancel() {
        this.close();
    }

    public void updateResourceList() {
        this.tagList.enable();
        this.tagList.show();
        TileEntity te = this.world.func_175625_s(this.anchorPos);
        if (te instanceof IBlueprintDataProvider) {
            IBlueprintDataProvider dataTE = (IBlueprintDataProvider)te;
            this.positionsList = new ArrayList<BlockPos>(dataTE.getPositionedTags().keySet());
        } else {
            this.close();
        }
        this.tagList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTagTool.this.positionsList.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                TileEntity te = WindowTagTool.this.world.func_175625_s(WindowTagTool.this.anchorPos);
                if (te instanceof IBlueprintDataProvider) {
                    IBlueprintDataProvider dataTE = (IBlueprintDataProvider)te;
                    WindowTagTool.this.positionsList = new ArrayList<BlockPos>(dataTE.getPositionedTags().keySet());
                    WindowTagTool.this.positionsList = new ArrayList<BlockPos>(dataTE.getPositionedTags().keySet());
                    BlockPos pos = (BlockPos)WindowTagTool.this.positionsList.get(index);
                    List<String> tags = dataTE.getPositionedTags().get(pos);
                    ItemStack displayStack = BlockUtils.getItemStackFromBlockState(WindowTagTool.this.world.func_180495_p(dataTE.getRealWorldPos(pos)));
                    rowPane.findPaneOfTypeByID(WindowTagTool.LIST_BLOCK, ItemIcon.class).setItem(displayStack);
                    Text tagsText = rowPane.findPaneOfTypeByID(WindowTagTool.TAG_TEXT, Text.class);
                    tagsText.setTextContent(tags.toString());
                } else {
                    WindowTagTool.this.close();
                }
            }
        });
    }
}

