/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;

public class MultipleStringArgument
implements ArgumentType<String> {
    private final BiFunction<CommandContext<CommandSource>, ServerPlayerEntity, Collection<String>> dataProvider;

    public MultipleStringArgument(BiFunction<CommandContext<CommandSource>, ServerPlayerEntity, Collection<String>> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public static MultipleStringArgument multipleString(BiFunction<CommandContext<CommandSource>, ServerPlayerEntity, Collection<String>> dataProvider) {
        return new MultipleStringArgument(dataProvider);
    }

    public static String getResult(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return StringArgumentType.string().parse(reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof ClientSuggestionProvider) {
            CommandContext<S> ctx = context;
            return ((ISuggestionProvider)ctx.getSource()).func_197009_a(ctx, builder);
        }
        CommandContext<S> ctx = context;
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        int cursorBegin = reader.getCursor();
        while (reader.canRead() && MultipleStringArgument.isValidCharacter(reader.peek())) {
            reader.skip();
        }
        String argument = reader.getString().substring(cursorBegin, reader.getCursor());
        int suggestionLength = argument.length();
        List<Object> suggestions = new ArrayList();
        try {
            for (String s : this.dataProvider.apply(ctx, ((CommandSource)ctx.getSource()).func_197035_h())) {
                if (argument.equals(s)) {
                    suggestions = Arrays.asList(s);
                    break;
                }
                if (!argument.equals(s.substring(0, suggestionLength))) continue;
                suggestions.add(s);
            }
        }
        catch (CommandSyntaxException | NullPointerException e) {
            return Suggestions.empty();
        }
        if (suggestions.isEmpty()) {
            return Suggestions.empty();
        }
        return ISuggestionProvider.func_197005_b(suggestions, (SuggestionsBuilder)builder);
    }

    private static boolean isValidCharacter(char charIn) {
        return charIn >= '!' && charIn <= '~';
    }
}

