/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structures.client.BlueprintHandler;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.client.renderer.PlaceholderTileEntityRenderer;
import com.ldtteam.structurize.generation.defaults.DefaultBlockLootTableProvider;
import com.ldtteam.structurize.generation.floating_carpets.FloatingCarpetsBlockStateProvider;
import com.ldtteam.structurize.generation.floating_carpets.FloatingCarpetsItemModelProvider;
import com.ldtteam.structurize.generation.floating_carpets.FloatingCarpetsLangEntryProvider;
import com.ldtteam.structurize.generation.floating_carpets.FloatingCarpetsRecipeProvider;
import com.ldtteam.structurize.generation.floating_carpets.FloatingCarpetsTagsProvider;
import com.ldtteam.structurize.generation.shingle_slabs.ShingleSlabsBlockModelProvider;
import com.ldtteam.structurize.generation.shingle_slabs.ShingleSlabsBlockStateProvider;
import com.ldtteam.structurize.generation.shingle_slabs.ShingleSlabsItemModelProvider;
import com.ldtteam.structurize.generation.shingle_slabs.ShingleSlabsLangEntryProvider;
import com.ldtteam.structurize.generation.shingle_slabs.ShingleSlabsRecipeProvider;
import com.ldtteam.structurize.generation.shingle_slabs.ShingleSlabsTagsProvider;
import com.ldtteam.structurize.generation.shingles.ShinglesBlockModelProvider;
import com.ldtteam.structurize.generation.shingles.ShinglesBlockStateProvider;
import com.ldtteam.structurize.generation.shingles.ShinglesItemModelProvider;
import com.ldtteam.structurize.generation.shingles.ShinglesLangEntryProvider;
import com.ldtteam.structurize.generation.shingles.ShinglesRecipeProvider;
import com.ldtteam.structurize.generation.shingles.ShinglesTagsProvider;
import com.ldtteam.structurize.generation.timber_frames.TimberFramesBlockModelProvider;
import com.ldtteam.structurize.generation.timber_frames.TimberFramesBlockStateProvider;
import com.ldtteam.structurize.generation.timber_frames.TimberFramesItemModelProvider;
import com.ldtteam.structurize.generation.timber_frames.TimberFramesLangEntryProvider;
import com.ldtteam.structurize.generation.timber_frames.TimberFramesRecipeProvider;
import com.ldtteam.structurize.generation.timber_frames.TimberFramesTagsProvider;
import com.ldtteam.structurize.optifine.OptifineCompat;
import com.ldtteam.structurize.tileentities.StructurizeTileEntities;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class LifecycleSubscriber {
    @SubscribeEvent
    public static void onModInit(FMLCommonSetupEvent event) {
        Network.getNetwork().registerCommonMessages();
        StructureLoadingUtils.originFolders.add("structurize");
    }

    @SubscribeEvent
    public static void onClientInit(FMLClientSetupEvent event) {
        ModBlocks.getTimberFrames().forEach(frame -> RenderTypeLookup.setRenderLayer((Block)frame, (RenderType)RenderType.func_228643_e_()));
        ModBlocks.getShingles().forEach(frame -> RenderTypeLookup.setRenderLayer((Block)frame, (RenderType)RenderType.func_228643_e_()));
        ModBlocks.getShingleSlabs().forEach(frame -> RenderTypeLookup.setRenderLayer((Block)frame, (RenderType)RenderType.func_228643_e_()));
        ModBlocks.getPaperwalls().forEach(frame -> RenderTypeLookup.setRenderLayer((Block)frame, (RenderType)RenderType.func_228645_f_()));
        ModBlocks.getFloatingCarpets().forEach(frame -> RenderTypeLookup.setRenderLayer((Block)frame, (RenderType)RenderType.func_228643_e_()));
        ClientRegistry.bindTileEntityRenderer(StructurizeTileEntities.PLACERHOLDER_BLOCK, PlaceholderTileEntityRenderer::new);
        OptifineCompat.getInstance().intialize();
        IResourceManager rm = ((Minecraft)event.getMinecraftSupplier().get()).func_195551_G();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_219534_a((IFutureReloadListener)new ISelectiveResourceReloadListener(){

                public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
                    if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS) || resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES) || resourcePredicate.test((IResourceType)VanillaResourceType.SHADERS)) {
                        Log.getLogger().debug("Clearing blueprint renderer cache.");
                        BlueprintHandler.getInstance().clearCache();
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        LanguageHandler.setMClanguageLoaded();
    }

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new ShinglesBlockStateProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShinglesItemModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShinglesBlockModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShinglesLangEntryProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShinglesRecipeProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShinglesTagsProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShingleSlabsBlockStateProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShingleSlabsItemModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShingleSlabsBlockModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShingleSlabsLangEntryProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShingleSlabsRecipeProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ShingleSlabsTagsProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new TimberFramesBlockStateProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new TimberFramesItemModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new TimberFramesBlockModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new TimberFramesLangEntryProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new TimberFramesRecipeProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new TimberFramesTagsProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new FloatingCarpetsBlockStateProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new FloatingCarpetsItemModelProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new FloatingCarpetsLangEntryProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new FloatingCarpetsRecipeProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new FloatingCarpetsTagsProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new DefaultBlockLootTableProvider(event.getGenerator()));
    }
}

