/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.shingles;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.ModelDisplayPositionJson;
import com.ldtteam.datagenerators.models.ModelDisplayPositionsEnum;
import com.ldtteam.datagenerators.models.XYZDoubleListJson;
import com.ldtteam.datagenerators.models.XYZIntListJson;
import com.ldtteam.datagenerators.models.item.ItemModelJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class ShinglesItemModelProvider
implements IDataProvider {
    private final DataGenerator generator;

    public ShinglesItemModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        ItemModelJson modelJson = new ItemModelJson();
        modelJson.setDisplay(this.getDisplayMap());
        for (BlockShingle shingle : ModBlocks.getShingles()) {
            String parent = "structurize:block/shingle/straight/" + shingle.getWoodType().func_176610_l() + "/" + shingle.getFaceType().func_176610_l() + "_shingle";
            modelJson.setParent(parent);
            if (shingle.getRegistryName() == null) continue;
            String name = shingle.getRegistryName().func_110623_a();
            IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)this.generator.func_200391_b().resolve("assets/structurize/models/item/").resolve(name + ".json"));
        }
    }

    private Map<ModelDisplayPositionsEnum, ModelDisplayPositionJson> getDisplayMap() {
        HashMap<ModelDisplayPositionsEnum, ModelDisplayPositionJson> display = new HashMap<ModelDisplayPositionsEnum, ModelDisplayPositionJson>();
        XYZIntListJson guiRotation = new XYZIntListJson(30, 225, 0);
        XYZDoubleListJson guiTranslation = new XYZDoubleListJson(-0.5, 1.0, 0.0);
        XYZDoubleListJson guiScale = new XYZDoubleListJson(0.54, 0.54, 0.54);
        ModelDisplayPositionJson guiPosition = new ModelDisplayPositionJson(guiRotation, guiTranslation, guiScale);
        display.put(ModelDisplayPositionsEnum.GUI, guiPosition);
        XYZIntListJson thirdPersonRotation = new XYZIntListJson(75, 45, 0);
        XYZDoubleListJson thirdPersonTranslation = new XYZDoubleListJson(0.0, 2.5, 0.0);
        XYZDoubleListJson thirdPersonScale = new XYZDoubleListJson(0.375, 0.375, 0.375);
        ModelDisplayPositionJson thirdPersonPosition = new ModelDisplayPositionJson(thirdPersonRotation, thirdPersonTranslation, thirdPersonScale);
        display.put(ModelDisplayPositionsEnum.THIRD_PERSON_LEFT_HAND, thirdPersonPosition);
        display.put(ModelDisplayPositionsEnum.THIRD_PERSON_RIGHT_HAND, thirdPersonPosition);
        XYZIntListJson firstPersonRotation = new XYZIntListJson(0, -145, 0);
        XYZDoubleListJson firstPersonTranslation = new XYZDoubleListJson(0.0, 3.25, 0.0);
        XYZDoubleListJson firstPersonScale = new XYZDoubleListJson(0.4, 0.4, 0.4);
        ModelDisplayPositionJson firstPersonPosition = new ModelDisplayPositionJson(firstPersonRotation, firstPersonTranslation, firstPersonScale);
        display.put(ModelDisplayPositionsEnum.FIRST_PERSON_LEFT_HAND, firstPersonPosition);
        display.put(ModelDisplayPositionsEnum.FIRST_PERSON_RIGHT_HAND, firstPersonPosition);
        XYZDoubleListJson groundTranslation = new XYZDoubleListJson(0.0, 3.0, 0.0);
        XYZDoubleListJson groundScale = new XYZDoubleListJson(0.25, 0.25, 0.25);
        ModelDisplayPositionJson groundPosition = new ModelDisplayPositionJson(null, groundTranslation, groundScale);
        display.put(ModelDisplayPositionsEnum.GROUND, groundPosition);
        XYZDoubleListJson fixedTranslation = new XYZDoubleListJson(0.0, 0.0, -3.5);
        XYZDoubleListJson fixedScale = new XYZDoubleListJson(0.5, 0.5, 0.5);
        ModelDisplayPositionJson fixedPosition = new ModelDisplayPositionJson(null, fixedTranslation, fixedScale);
        display.put(ModelDisplayPositionsEnum.FIXED, fixedPosition);
        XYZDoubleListJson headTranslation = new XYZDoubleListJson(0.0, 13.5, 0.0);
        ModelDisplayPositionJson headPosition = new ModelDisplayPositionJson(null, headTranslation, null);
        display.put(ModelDisplayPositionsEnum.HEAD, headPosition);
        return display;
    }

    @NotNull
    public String func_200397_b() {
        return "Shingles Item Model Provider";
    }
}

