/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.shingles;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.recipes.RecipeIngredientJson;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedPatternJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedRecipeJson;
import com.ldtteam.datagenerators.recipes.shapeless.ShaplessRecipeJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class ShinglesRecipeProvider
implements IDataProvider {
    private final DataGenerator generator;

    public ShinglesRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockShingle shingle : ModBlocks.getShingles()) {
            if (!shingle.getFaceType().isDyed()) {
                this.createBasicShingleRecipe(cache, shingle);
                continue;
            }
            this.createDyableShingleRecipe(cache, shingle);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Shingles Recipes";
    }

    private void createDyableShingleRecipe(DirectoryCache cache, BlockShingle shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        ShaplessRecipeJson recipeJson = new ShaplessRecipeJson();
        String groupName = shingle.getFaceType().getGroup() + "_" + shingle.getWoodType().func_176610_l() + "_shingle";
        recipeJson.setGroup(groupName);
        recipeJson.setResult(new RecipeResultJson(8, shingle.getRegistryName().toString()));
        ArrayList<RecipeIngredientKeyJson> ingredients = new ArrayList<RecipeIngredientKeyJson>();
        ingredients.add(new RecipeIngredientKeyJson(new RecipeIngredientJson(shingle.getFaceType().getRecipeIngredient(), false)));
        for (int i = 0; i < 8; ++i) {
            ingredients.add(new RecipeIngredientKeyJson(new RecipeIngredientJson("structurize:shingles/" + shingle.getFaceType().getGroup() + "/" + shingle.getWoodType().func_176610_l(), true)));
        }
        recipeJson.setIngredients(ingredients);
        Path recipePath = this.generator.func_200391_b().resolve("data/structurize//recipes/").resolve(shingle.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)recipeJson), (Path)recipePath);
    }

    private void createBasicShingleRecipe(DirectoryCache cache, BlockShingle shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        String groupName = shingle.getFaceType().func_176610_l() + "_shingle";
        ShapedRecipeJson recipeJson = new ShapedRecipeJson();
        recipeJson.setGroup(groupName);
        recipeJson.setResult(new RecipeResultJson(8, shingle.getRegistryName().toString()));
        recipeJson.setPattern(new ShapedPatternJson("I  ", "SI ", "PSI"));
        HashMap<String, RecipeIngredientKeyJson> ingredients = new HashMap<String, RecipeIngredientKeyJson>();
        ingredients.put("I", new RecipeIngredientKeyJson(new RecipeIngredientJson(shingle.getFaceType().getRecipeIngredient(), false)));
        ingredients.put("S", new RecipeIngredientKeyJson(new RecipeIngredientJson("minecraft:stick", false)));
        ingredients.put("P", new RecipeIngredientKeyJson(new RecipeIngredientJson(shingle.getWoodType().getRecipeIngredient(), false)));
        recipeJson.setKey(ingredients);
        Path recipePath = this.generator.func_200391_b().resolve("data/structurize//recipes/").resolve(shingle.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)recipeJson), (Path)recipePath);
    }
}

