/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.timber_frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.NotNull;

public class TimberFramesBlockStateProvider
implements IDataProvider {
    private final DataGenerator generator;

    public TimberFramesBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockTimberFrame timberFrame : ModBlocks.getTimberFrames()) {
            this.createBlockstateFile(cache, timberFrame);
        }
    }

    private void createBlockstateFile(DirectoryCache cache, BlockTimberFrame timberFrame) throws IOException {
        if (timberFrame.getRegistryName() == null) {
            return;
        }
        HashMap<String, BlockstateVariantJson> variants = new HashMap<String, BlockstateVariantJson>();
        for (Direction direction : BlockTimberFrame.FACING.func_177700_c()) {
            String modelLocation = "structurize:block/timber_frames/" + timberFrame.getTimberFrameType().func_176610_l() + "_" + timberFrame.getFrameType().func_176610_l() + "_" + timberFrame.getCentreType().func_176610_l() + "_timber_frame";
            int x = 0;
            int y = 0;
            if (timberFrame.getTimberFrameType().isRotatable()) {
                x = this.getXfromDirection(direction);
                y = this.getYfromDirection(direction);
            }
            BlockstateModelJson model = new BlockstateModelJson(modelLocation, x, y);
            BlockstateVariantJson variant = new BlockstateVariantJson(model);
            variants.put("facing=" + direction.func_176610_l(), variant);
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.func_200391_b().resolve("assets/structurize/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(timberFrame.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    private int getXfromDirection(Direction direction) {
        switch (direction) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 180;
            }
        }
        return 90;
    }

    private int getYfromDirection(Direction direction) {
        switch (direction) {
            default: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: 
        }
        return 270;
    }

    @NotNull
    public String func_200397_b() {
        return "Timber Frames BlockStates Provider";
    }
}

